<?php
session_start();
require_once 'db.php'; // ✅ Updated to use the new PDO connection

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

try {
    // ✅ Using PDO now
    $stmt = $conn->prepare("SELECT is_admin, firstName, lastName FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || $user['is_admin'] != 1) {
        header("Location: index.php");
        exit();
    }

    $is_admin = $user['is_admin'];
    $firstName = $user['firstName'];
    $lastName = $user['lastName'];
    $displayName = trim(($firstName ?? '') . ' ' . ($lastName ?? ''));
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

// Cart count
$cart_count = 0;
if (isset($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $item) $cart_count += $item['quantity'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Responsive scaling -->
<title>Admin Dashboard - Taji Yetu</title>

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

<!-- Sidebar CSS -->
<link rel="stylesheet" href="admin-sidebar.css">

<style>
.dashboard-wrapper {
    display: flex;
    min-height: calc(100vh - 60px); /* offset navbar height */
    margin-top: 60px; /* since navbar is fixed */
}
.main-content {
    flex: 1;
    padding: 20px;
    background: url('images/bg.jpg') center/cover no-repeat fixed;
    color: #fff;
}
.hero {
    display:flex;
    justify-content:center;
    align-items:center;
    padding:80px 20px 20px;
}
.overlay-text {
    display:flex;
    align-items:center;
    gap:20px;
    background: rgba(0,0,0,0.7);
    padding:20px;
    border-radius:10px;
    max-width:90%;
    flex-wrap:wrap;
}
.overlay-text img { width:100px; border-radius:8px; flex-shrink:0; }
.overlay-text .text-content { flex:1; font-size:22px; line-height:1.4; }
.gallery {
    display:flex;
    justify-content:center;
    gap:10px;
    padding:30px 10px;
    flex-wrap:wrap;
}
.gallery img {
    width:140px;
    height:200px;
    object-fit:cover;
    border-radius:10px;
    filter:grayscale(100%);
    transition: transform 0.3s ease;
}
.gallery img:hover {
    transform: scale(1.05);
    filter: grayscale(0%);
}
.shop-button {
    display:flex;
    justify-content:center;
    margin:20px auto;
}
.shop-button button {
    background:#fff;
    color:#000;
    padding:12px 30px;
    font-size:18px;
    border:none;
    border-radius:5px;
    cursor:pointer;
    font-weight:bold;
    transition:0.3s ease;
}
.shop-button button:hover { background:#ccc; }
</style>
</head>
<body>

<?php include "navbar.php"; ?>

<div class="dashboard-wrapper">
    <?php include "admin-sidebar.php"; ?>

    <div class="main-content">
        <section class="hero">
            <div class="overlay-text">
                <img src="images/bg.jpg" alt="Model">
                <div class="text-content">
                    <p>Welcome to the Admin Dashboard. You can manage users as well as shop for clothes!</p>
                </div>
            </div>
        </section>

        <section class="gallery">
            <img src="images/bw.jpeg" alt="Outfit 1">
            <img src="images/girl.jpeg" alt="Outfit 2">
            <img src="images/cargo pants.jpeg" alt="Outfit 3">
            <img src="images/girl2.jpeg" alt="Outfit 4">
            <img src="images/short black.jpeg" alt="Outfit 5">
        </section>

        <div class="shop-button">
            <button onclick="window.location.href='listing.php'">Shop Now</button>
        </div>
    </div>
</div>

<?php include "footer.php"; ?>

<!-- Sidebar Toggle Script -->
<script src="admin-sidebar.js"></script>
</body>
</html>
