<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
  if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
  $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
  header("Location: login.php");
  exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

$sql = "SELECT order_id, order_date, status, total FROM orders WHERE user_id = ? ORDER BY order_date DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>My Orders - Taji Yetu</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #000;
      color: #fff;
    }
    header, footer {
      background: #111;
      padding: 15px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: #fff;
    }
    header .logo img {
      height: 50px;
    }
    .container {
      max-width: 900px;
      margin: 40px auto;
      background: #fff;
      color: #000;
      border-radius: 10px;
      padding: 25px;
    }
    h2 {
      text-align: center;
      margin-bottom: 25px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border-bottom: 1px solid #ccc;
      text-align: center;
    }
    th {
      background: #eee;
    }
    tr:hover {
      background-color: #f2f2f2;
    }
    footer {
      text-align: center;
      font-size: 14px;
    }
  </style>
</head>
<body>
<!-- Header -->
<header>
  <div class="header-left">
    <a href="/Bela/index.php" class="logo"><img src="/Bella/images/TAJI YETU.PNG" alt="Logo"></a>
  </div>
  <div class="header-right">
    <a href="/Bella/cart.php" style="color:white;"><i class="fas fa-shopping-cart"></i></a>
    <div class="account-dropdown">
      <button class="account-button">
        <?= isset($_SESSION['name']) ? htmlspecialchars($_SESSION['name']) : 'Account' ?>
        <i class="fas fa-caret-down"></i>
      </button>
      <div class="dropdown-menu">
        <a href="/Bella/profile.php">Profile</a>
        <a href="/Bell/orders.php">Orders</a>
        <a href="/Bella/logout.php">Logout</a>
      </div>
    </div>
  </div>
</header>

<div class="container">
  <h2>My Orders</h2>
  <?php if ($result->num_rows > 0): ?>
    <table>
      <thead>
        <tr>
          <th>Order ID</th>
          <th>Date</th>
          <th>Status</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($row['order_id']) ?></td>
            <td><?= htmlspecialchars(date('d M Y', strtotime($row['order_date']))) ?></td>
            <td><?= htmlspecialchars(ucfirst($row['status'])) ?></td>
            <td>Ksh <?= number_format($row['total'], 2) ?></td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  <?php else: ?>
    <p style="text-align:center;">You have not placed any orders yet.</p>
  <?php endif; ?>
</div>

<!-- Footer -->
<footer>
  <p>&copy; <?= date('Y') ?> Taji Yetu. All rights reserved.</p>
</footer>
</body>
</html>
