<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Belagidds - Home</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      margin: 0;
      background: #111; /* Clean dark background */
      color: #fff;
      display: flex;
      flex-direction: column;
      min-height: 100vh; /* Full page height */
    }

    /* Navbar */
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 12px 20px;
      background-color: rgba(17, 17, 17, 0.95);
      flex-wrap: wrap;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 15px;
    }
    .logo img {
      height: 40px;
    }
    .belagidds-btn {
      background: #444;
      color: #fff;
      border: none;
      padding: 6px 12px;
      border-radius: 5px;
      cursor: pointer;
    }
    .header-right {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-wrap: wrap;
    }
    .cart-icon { font-size: 1.3rem; color: white; }

    .cart-wrapper {
      position: relative;
      display: inline-block;
    }
    .cart-badge {
      position: absolute;
      top: -8px;
      right: -10px;
      background: red;
      color: white;
      font-size: 10px;
      font-weight: bold;
      border-radius: 50%;
      padding: 2px 6px;
      min-width: 15px;
      text-align: center;
    }

    .account-dropdown { position: relative; }
    .account-button {
      background: #444;
      color: #fff;
      border: none;
      padding: 6px 12px;
      border-radius: 5px;
      cursor: pointer;
    }
    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background: #222;
      border-radius: 5px;
      overflow: hidden;
      z-index: 10;
    }
    .dropdown-menu a {
      display: block;
      padding: 8px 12px;
      color: #fff;
      text-decoration: none;
    }
    .dropdown-menu a:hover { background: #333; }
    .account-dropdown:hover .dropdown-menu { display: block; }

    /* Hero Section */
    .hero {
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 50px 20px;
      background: url('images/bg.jpg') center/cover no-repeat;
      background-attachment: scroll; /* mobile safe */
      flex-wrap: wrap;
      gap: 20px;
      min-height: 100vh; /* Full viewport height */
      box-sizing: border-box;
    }
    .hero img {
      width: 280px;
      border-radius: 10px;
      flex-shrink: 0;
    }
    .hero .text-content {
      max-width: 500px;
      font-size: 18px;
      line-height: 1.6;
      background: rgba(0,0,0,0.6);
      padding: 20px;
      border-radius: 10px;
    }

    /* Shop button */
    .shop-button {
      display: flex;
      justify-content: center;
      margin: 25px auto;
    }
    .shop-button button {
      background: #fff;
      color: #000;
      padding: 12px 28px;
      font-size: 18px;
      border: none;
      cursor: pointer;
      border-radius: 5px;
      transition: 0.3s;
    }
    .shop-button button:hover { background: #ccc; }

    /* Gallery */
    .gallery {
      display: flex;
      overflow-x: auto;
      scroll-snap-type: x mandatory;
      gap: 15px;
      padding: 20px;
      background: rgba(0,0,0,0.9);
    }
    .gallery img {
      flex: 0 0 calc(33.333% - 10px);
      height: 220px;
      object-fit: cover;
      border-radius: 10px;
      scroll-snap-align: start;
      filter: grayscale(100%);
      transition: 0.3s ease;
    }
    .gallery img:hover {
      filter: grayscale(0);
      transform: scale(1.05);
    }

    /* Footer */
    footer {
      background: rgba(17, 17, 17, 0.95);
      padding: 25px 15px;
      text-align: center;
      margin-top: auto; /* Pushes footer to bottom */
    }
    .social-icons a {
      color: #fff;
      font-size: 1.3rem;
      margin: 0 8px;
      transition: color 0.3s;
    }
    .social-icons a:hover { color: #aaa; }
    .copyright { margin-top: 12px; font-size: 0.9rem; color: #bbb; }

    /* Responsive */
    @media (max-width: 900px) {
      .gallery img { flex: 0 0 calc(50% - 10px); }
      .hero { text-align: center; }
      .hero img { width: 220px; }
    }
    @media (max-width: 600px) {
      .gallery img { flex: 0 0 100%; }
      .hero { flex-direction: column; min-height: auto; }
      .hero img { width: 100%; max-width: 300px; }
    }
  </style>
</head>
<body>

<!-- Header -->
<header>
  <div class="header-left">
    <a href="/Bella/index.php" class="logo"><img src="/Bella/images/TAJI YETU.png" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
    <a href="/Bella/cart.php" class="cart-wrapper">
      <i class="fas fa-shopping-cart cart-icon"></i>
      <span class="cart-badge">2</span>
    </a>

    <div class="account-dropdown">
      <button class="account-button">Account <i class="fas fa-caret-down"></i></button>
      <div class="dropdown-menu">
        <a href="/Bella/profile.php">Profile</a>
        <a href="/Bella/orders.php">Orders</a>
        <a href="/Bella/logout.php">Logout</a>
      </div>
    </div>
  </div>
</header>

<!-- Hero -->
<section class="hero">
  <img src="images/bg.jpg" alt="Hero Image">
  <div class="text-content">
    <p>90% of the money made from these Belagids outfits goes into the development and advancement of the Belagids vision.</p>
  </div>
</section>

<!-- Shop Now -->
<div class="shop-button">
  <button onclick="window.location.href='listing.php'">Shop now</button>
</div>

<!-- Gallery -->
<section class="gallery">
  <img src="images/bw.jpeg" alt="Outfit 1">
  <img src="images/girl.jpeg" alt="Outfit 2">
  <img src="images/cargo pants.jpeg" alt="Outfit 3">
  <img src="images/girl2.jpeg" alt="Outfit 4">
  <img src="images/short black.jpeg" alt="Outfit 5">
</section>

<!-- Footer -->
<footer>
  <div class="social-icons">
    <a href="#"><i class="fab fa-facebook-f"></i></a>
    <a href="#"><i class="fab fa-twitter"></i></a>
    <a href="#"><i class="fab fa-instagram"></i></a>
    <a href="#"><i class="fab fa-tiktok"></i></a>
  </div>
  <div class="copyright">
    &copy; 2025 TAJI YETU. All rights reserved.
  </div>
</footer>

</body>
</html>
