<?php
session_start();

// Connect to DB
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");
if ($conn->connect_error) die("DB connection failed: " . $conn->connect_error);

// Fetch users
$users = $conn->query("SELECT id, firstName, lastName, email, phone, created_at FROM users");

// Fetch checkout attempts (covers both successful + failed/abandoned)
$checkouts = $conn->query("SELECT * FROM checkout_attempts ORDER BY created_at DESC");

// Sales summary from checkout attempts
$sales = $conn->query("
    SELECT 
        COUNT(CASE WHEN status = 'completed' THEN 1 END) as total_orders, 
        SUM(CASE WHEN status = 'completed' THEN total_amount END) as total_revenue,
        COUNT(CASE WHEN status = 'abandoned' THEN 1 END) as abandoned_orders,
        COUNT(CASE WHEN status = 'failed' THEN 1 END) as failed_orders
    FROM checkout_attempts
")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard - Bella</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background: #111;
      color: #eee;
    }
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 30px;
      background: #000;
    }
    .logo img { height: 40px; }
    .nav-tabs {
      display: flex;
      gap: 20px;
      background: #222;
      padding: 10px 20px;
    }
    .nav-tabs button {
      background: transparent;
      border: none;
      color: #fff;
      padding: 10px 15px;
      cursor: pointer;
      font-size: 16px;
    }
    .nav-tabs button.active {
      background: #444;
      border-radius: 6px;
    }
    .tab-content {
      padding: 20px;
      display: none;
    }
    .tab-content.active {
      display: block;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 15px;
    }
    th, td {
      border: 1px solid #444;
      padding: 8px;
      text-align: left;
    }
    th {
      background: #222;
    }
    .stats {
      display: flex;
      gap: 20px;
      margin-top: 20px;
    }
    .card {
      background: #222;
      padding: 20px;
      border-radius: 8px;
      flex: 1;
      text-align: center;
    }
  </style>
</head>
<body>
<header>
  <div class="logo">
    <img src="/Bella/images/TAJI YETU.png" alt="Logo">
  </div>
  <h2>Admin Dashboard</h2>
</header>

<div class="nav-tabs">
  <button class="active" onclick="showTab('users')"><i class="fas fa-users"></i> Users</button>
  <button onclick="showTab('checkouts')"><i class="fas fa-box"></i> Checkout Attempts</button>
  <button onclick="showTab('sales')"><i class="fas fa-chart-line"></i> Sales</button>
</div>

<div class="tab-content active" id="users">
  <h3>Registered Users</h3>
  <table>
    <tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Joined</th></tr>
    <?php while($u = $users->fetch_assoc()): ?>
    <tr>
      <td><?= $u['id'] ?></td>
      <td><?= htmlspecialchars($u['firstName']." ".$u['lastName']) ?></td>
      <td><?= htmlspecialchars($u['email']) ?></td>
      <td><?= htmlspecialchars($u['phone']) ?></td>
      <td><?= $u['created_at'] ?></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>

<div class="tab-content" id="checkouts">
  <h3>Checkout Attempts</h3>
  <table>
    <tr><th>ID</th><th>User ID</th><th>Total</th><th>Status</th><th>Date</th></tr>
    <?php while($c = $checkouts->fetch_assoc()): ?>
    <tr>
      <td><?= $c['id'] ?></td>
      <td><?= $c['user_id'] ?></td>
      <td>Ksh <?= number_format($c['total_amount']) ?></td>
      <td><?= ucfirst($c['status']) ?></td>
      <td><?= $c['created_at'] ?></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>

<div class="tab-content" id="sales">
  <h3>Sales Dashboard</h3>
  <div class="stats">
    <div class="card">
      <h2><?= $sales['total_orders'] ?? 0 ?></h2>
      <p>Total Completed Orders</p>
    </div>
    <div class="card">
      <h2>Ksh <?= number_format($sales['total_revenue'] ?? 0) ?></h2>
      <p>Total Revenue</p>
    </div>
    <div class="card">
      <h2><?= $sales['abandoned_orders'] ?? 0 ?></h2>
      <p>Abandoned Checkouts</p>
    </div>
    <div class="card">
      <h2><?= $sales['failed_orders'] ?? 0 ?></h2>
      <p>Failed Payments</p>
    </div>
  </div>
</div>

<script>
  function showTab(tab) {
    document.querySelectorAll('.tab-content').forEach(div => div.classList.remove('active'));
    document.querySelectorAll('.nav-tabs button').forEach(btn => btn.classList.remove('active'));
    document.getElementById(tab).classList.add('active');
    event.target.classList.add('active');
  }
</script>
</body>
</html>
