<?php
// Show errors (remove this after debugging on live)
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
  if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']); // Clear user session if timeout
  $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
  header("Location: login.php");
  exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

// Fetch user basic info
$userStmt = $conn->prepare("SELECT firstName, lastName, email, phone, profile_pic FROM users WHERE id = ?");
$userStmt->bind_param("i", $userId);
$userStmt->execute();
$userStmt->bind_result($firstName, $lastName, $email, $phone, $profilePic);
$userStmt->fetch();
$userStmt->close();

// Make sure we have a display name (fixes the $_SESSION['name'] issue)
$displayName = trim($firstName . " " . $lastName);

// Fetch user measurements
$measStmt = $conn->prepare("SELECT chest, waist, hips, bust, shoulders, gender FROM measurements WHERE user_id = ?");
$measStmt->bind_param("i", $userId);
$measStmt->execute();
$measStmt->bind_result($chest, $waist, $hips, $bust, $shoulders, $gender);
$measStmt->fetch();
$measStmt->close();

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>My Profile - Taji Yetu</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #000;
      color: #fff;
    }
    header {
      background: #111;
      padding: 15px 30px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      position: relative;
    }
    .header-left {
      display: flex;
      align-items: center;
    }
    .logo img {
      height: 40px;
    }
    .belagidds-btn {
      background: #fff;
      border: none;
      padding: 8px 12px;
      margin-left: 20px;
      cursor: pointer;
    }
    .header-right {
      display: flex;
      align-items: center;
      gap: 20px;
    }
    .cart-wrapper {
      position: relative;
      color: #fff;
      text-decoration: none;
    }
    .cart-badge {
      background: red;
      color: white;
      border-radius: 50%;
      padding: 2px 6px;
      position: absolute;
      top: -8px;
      right: -10px;
      font-size: 12px;
    }
    .account-dropdown {
      position: relative;
    }
    .account-button {
      background: none;
      border: none;
      color: #fff;
      cursor: pointer;
    }
    .dropdown-menu {
      display: none;
      position: absolute;
      background: #222;
      top: 30px;
      right: 0;
      padding: 10px;
      border-radius: 5px;
    }
    .account-dropdown:hover .dropdown-menu {
      display: block;
    }
    .dropdown-menu a {
      display: block;
      color: #fff;
      text-decoration: none;
      margin-bottom: 8px;
    }
    .container {
      max-width: 900px;
      margin: 30px auto;
      background: #fff;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.2);
      color: #000;
    }
    h1 {
      text-align: center;
      margin-bottom: 30px;
    }
    .profile-wrapper {
      display: flex;
      flex-wrap: wrap;
      gap: 30px;
    }
    .profile-left, .profile-right {
      flex: 1;
      min-width: 250px;
    }
    .profile-pic {
      text-align: center;
      margin-bottom: 20px;
    }
    .profile-pic img {
      width: 120px;
      height: 120px;
      object-fit: cover;
      border-radius: 50%;
      border: 3px solid #000;
      cursor: pointer;
    }
    .info-group {
      margin-bottom: 12px;
    }
    .info-group label {
      font-weight: 600;
      display: block;
      margin-bottom: 3px;
      font-size: 14px;
    }
    .info-group p {
      margin: 0;
      color: #333;
      background: #eee;
      padding: 8px 10px;
      border-radius: 4px;
      font-size: 14px;
    }
    .actions {
      text-align: center;
      margin-top: 25px;
    }
    .actions a {
      background: #000;
      color: #fff;
      padding: 8px 15px;
      margin: 0 8px;
      border-radius: 5px;
      text-decoration: none;
      font-size: 14px;
    }
    .actions a:hover {
      background: #444;
    }
    footer {
      background-color: rgba(17, 17, 17, 0.8);
      padding: 30px 20px;
      text-align: center;
    }
    .social-icons {
      margin-bottom: 15px;
    }
    .social-icons a {
      color: #fff;
      font-size: 1.4rem;
      margin: 0 10px;
      transition: color 0.3s;
    }
    .social-icons a:hover {
      color: #888;
    }
    .copyright {
      font-size: 0.9rem;
      color: #aaa;
    }
  </style>
</head>
<body>
<!-- Header -->
<header>
  <div class="header-left">
    <a href="index.php" class="logo"><img src="images/TAJI YETU.png" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
    <a href="cart.php" class="cart-wrapper">
      <i class="fas fa-shopping-cart cart-icon"></i>
      <?php
        $cart_count = 0;
        if (isset($_SESSION['cart'])) {
          foreach ($_SESSION['cart'] as $item) {
            $cart_count += $item['quantity'];
          }
        }
      ?>
      <span class="cart-badge"><?= $cart_count ?></span>
    </a>

    <div class="account-dropdown">
      <button class="account-button">
        <?php if (isset($_SESSION['user_id'])): ?>
          <?= htmlspecialchars($displayName) ?>
        <?php else: ?>
          Account
        <?php endif; ?>
        <i class="fas fa-caret-down"></i>
      </button>

      <div class="dropdown-menu">
        <?php if (isset($_SESSION['user_id'])): ?>
          <a href="profile.php">Profile</a>
          <a href="orders.php">Orders</a>
          <a href="logout.php">Logout</a>
        <?php else: ?>
          <a href="login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>

<div class="container">
  <h1>My Profile</h1>
  <div class="profile-pic">
    <form action="upload-profile-pic.php" method="post" enctype="multipart/form-data" id="picForm">
      <input type="file" name="profile_pic" id="fileInput" style="display:none" onchange="document.getElementById('picForm').submit()">
      <label for="fileInput">
        <img src="<?= $profilePic ? htmlspecialchars($profilePic) : 'images/default-user.png' ?>" alt="Profile Picture">
      </label>
    </form>
    <p style="font-size: 13px; color: #777; margin-top: 8px;">Click picture to change</p>
  </div>
  <div class="profile-wrapper">
    <div class="profile-left">
      <div class="info-group">
        <label>First Name:</label>
        <p><?= htmlspecialchars($firstName) ?></p>
      </div>
      <div class="info-group">
        <label>Last Name:</label>
        <p><?= htmlspecialchars($lastName) ?></p>
      </div>
      <div class="info-group">
        <label>Email:</label>
        <p><?= htmlspecialchars($email) ?></p>
      </div>
      <div class="info-group">
        <label>Phone:</label>
        <p><?= htmlspecialchars($phone) ?></p>
      </div>
    </div>
    <div class="profile-right">
      <h3 style="margin-top: 0">Measurements</h3>
      <div class="info-group">
        <label>Gender:</label>
        <p><?= htmlspecialchars($gender) ?></p>
      </div>
      <div class="info-group">
        <label>Chest:</label>
        <p><?= htmlspecialchars($chest) ?> cm</p>
      </div>
      <div class="info-group">
        <label>Waist:</label>
        <p><?= htmlspecialchars($waist) ?> cm</p>
      </div>
      <div class="info-group">
        <label>Shoulders:</label>
        <p><?= htmlspecialchars($shoulders) ?> cm</p>
      </div>
      <div class="info-group">
        <label>Bust:</label>
        <p><?= htmlspecialchars($bust) ?> cm</p>
      </div>
    </div>
  </div>
  <div class="actions">
    <a href="edit-profile.php">Edit Profile</a>
    <a href="edit-measurements.php">Edit Measurements</a>
    <a href="logout.php">Logout</a>
  </div>
</div>

<footer>
  <div class="social-icons">
    <a href="#"><i class="fab fa-facebook-f"></i></a>
    <a href="#"><i class="fab fa-twitter"></i></a>
    <a href="#"><i class="fab fa-instagram"></i></a>
    <a href="#"><i class="fab fa-tiktok"></i></a>
  </div>
  <div class="copyright">
    &copy; 2025 TAJI YETU. All rights reserved.
  </div>
</footer>
</body>
</html>
