<?php
session_start();
require_once 'db.php';

$token = $_GET['token'] ?? '';
$error = '';
$success = '';

if (!$token) die("Invalid or missing token.");

// Check token
$stmt = $conn->prepare("SELECT pr.id, pr.user_id, pr.expires_at FROM password_resets pr WHERE pr.token = :token");
$stmt->bindValue(':token', $token, PDO::PARAM_STR);
$stmt->execute();
$reset = $stmt->fetch();

if (!$reset) die("Invalid or expired token.");

if (strtotime($reset['expires_at']) < time()) die("This reset link has expired. Request a new one.");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';

    if ($password !== $confirm) {
        $error = "❌ Passwords do not match.";
    } elseif (strlen($password) < 6) {
        $error = "❌ Password must be at least 6 characters.";
    } else {
        $hashed = password_hash($password, PASSWORD_DEFAULT);

        // Update password
        $stmtUpdate = $conn->prepare("UPDATE users SET password=:password WHERE id=:uid");
        $stmtUpdate->bindValue(':password', $hashed, PDO::PARAM_STR);
        $stmtUpdate->bindValue(':uid', $reset['user_id'], PDO::PARAM_INT);
        $stmtUpdate->execute();

        // Delete token
        $stmtDelete = $conn->prepare("DELETE FROM password_resets WHERE id=:id");
        $stmtDelete->bindValue(':id', $reset['id'], PDO::PARAM_INT);
        $stmtDelete->execute();

        $success = "✅ Your password has been reset. <a href='login.php'>Login now</a>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Reset Password - Taji Yetu</title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:wght@700&display=swap" rel="stylesheet">
<style>
body { font-family:'Old Standard TT', serif; margin:0; background:#000; color:#fff; position:relative; overflow-x:hidden; min-height:100vh; display:flex; justify-content:center; align-items:center; }
#particles-bg { position:fixed; top:0; left:0; width:100%; height:100%; z-index:0; pointer-events:none; }
.container { background: rgba(0,0,0,0.85); padding:30px; border-radius:12px; width:100%; max-width:400px; box-shadow:0 0 10px rgba(255,255,255,0.3); z-index:2; animation:fadeUp 1.2s ease forwards; }
@keyframes fadeUp {0%{opacity:0; transform:translateY(30px);} 100%{opacity:1; transform:translateY(0);} }
h2 { text-align:center; margin-bottom:25px; }
form { display:flex; flex-direction:column; }
input { padding:10px; margin-bottom:20px; border-radius:6px; border:none; background:#222; color:#fff; }
input:focus { outline:none; box-shadow:0 0 5px #fff; }
button { padding:12px; border:none; border-radius:8px; background:#fff; color:#000; font-weight:bold; cursor:pointer; transition:0.3s; }
button:hover { background:#000; color:#fff; transform:scale(1.05); }
.error { color:#ff8080; margin-bottom:15px; text-align:center; }
.success { color:#80ff80; margin-bottom:15px; text-align:center; }
a { color:#fff; text-decoration:none; } a:hover { text-decoration:underline; color:#ccc; }
@media(max-width:480px){ .container{ padding:20px; margin:20px; } }
</style>
</head>
<body>
<canvas id="particles-bg"></canvas>

<div class="container">
<h2>Reset Password</h2>

<?php if($error) echo "<div class='error'>$error</div>"; ?>
<?php if($success) echo "<div class='success'>$success</div>"; ?>

<?php if(!$success): ?>
<form method="POST">
    <input type="password" name="password" placeholder="New password" required>
    <input type="password" name="confirm" placeholder="Confirm new password" required>
    <button type="submit">Reset Password</button>
</form>
<?php endif; ?>
</div>

<script>
const canvas = document.getElementById('particles-bg');
const ctx = canvas.getContext('2d');
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;

let particles = [];
for(let i=0;i<80;i++){
    particles.push({x:Math.random()*canvas.width, y:Math.random()*canvas.height, r:2+Math.random()*2});
}

function animate(){
    ctx.clearRect(0,0,canvas.width,canvas.height);
    particles.forEach(p=>{
        ctx.beginPath();
        ctx.arc(p.x,p.y,p.r,0,Math.PI*2);
        ctx.fillStyle = 'white';
        ctx.fill();
        p.y -= 0.3;
        if(p.y < 0) p.y = canvas.height;
    });
    requestAnimationFrame(animate);
}
animate();

window.addEventListener('resize', ()=>{canvas.width=window.innerWidth; canvas.height=window.innerHeight;});
</script>
</body>
</html>
