<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Force login for pages that call require_login()
function require_login() {
    if (!isset($_SESSION['user_id'])) {
        $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
        header("Location: login.php");
        exit;
    }
}

// Helpers (always available globally)
$isLoggedIn = isset($_SESSION['user_id']);
$firstName  = $_SESSION['firstName'] ?? '';
$isAdmin    = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
