<?php
session_start();
require_once 'require_login.php';
require_once 'db.php';

// Ensure admin access
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    http_response_code(403);
    exit();
}

// Fetch stock info using PDO
$stmt = $conn->query("SELECT stock FROM products");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

$outOfStock = count(array_filter($products, fn($p) => $p['stock'] == 0));
$totalInStock = array_sum(array_column($products, 'stock'));
$totalProducts = count($products);

$data = [
    'outOfStock' => $outOfStock,
    'totalInStock' => $totalInStock,
    'totalProducts' => $totalProducts
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Stock Dashboard - Bella</title>
<link rel="icon" href="images/taji-yetu.png" type="image/png">
<style>
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #000;
    color: #fff;
    overflow-x: hidden;
}
canvas#bgAnimation {
    position: fixed;
    top: 0;
    left: 0;
    z-index: 1;
    width: 100%;
    height: 100%;
    background: #000;
}
.navbar {
    width: 100%;
    background: #111;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 30px;
    position: fixed;
    top: 0;
    z-index: 10;
    box-shadow: 0 2px 6px rgba(255,255,255,0.1);
}
.navbar a {
    color: #fff;
    text-decoration: none;
    margin-left: 20px;
    font-weight: 500;
}
.navbar a:hover {
    text-decoration: underline;
}
.admin-content {
    margin-top: 100px;
    padding: 30px;
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    z-index: 2;
    position: relative;
}
.card-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 20px;
    width: 100%;
    max-width: 900px;
}
.card {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(255,255,255,0.1);
    border-radius: 12px;
    text-align: center;
    padding: 25px;
    transition: all 0.3s ease;
}
.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 0 12px rgba(255,255,255,0.3);
}
.card h3 {
    margin: 10px 0;
    font-size: 18px;
    color: #fff;
}
.card p {
    font-size: 24px;
    font-weight: bold;
    color: #ccc;
}
@media (max-width: 768px) {
    .navbar {
        flex-direction: column;
        padding: 15px;
    }
    .navbar a {
        margin: 10px 0;
    }
    .admin-content {
        align-items: center;
    }
}
</style>
</head>
<body>
<canvas id="bgAnimation"></canvas>

<div class="navbar">
    <div class="logo"><a href="admin-dashboard.php">Bella Admin</a></div>
    <div class="nav-links">
        <a href="admin-products.php">Products</a>
        <a href="admin-orders.php">Orders</a>
        <a href="logout.php">Logout</a>
    </div>
</div>

<div class="admin-content">
    <div class="card-container">
        <div class="card">
            <h3>Total Products</h3>
            <p id="totalProducts"><?php echo $data['totalProducts']; ?></p>
        </div>
        <div class="card">
            <h3>Total In Stock</h3>
            <p id="totalInStock"><?php echo $data['totalInStock']; ?></p>
        </div>
        <div class="card">
            <h3>Out of Stock</h3>
            <p id="outOfStock"><?php echo $data['outOfStock']; ?></p>
        </div>
    </div>
</div>

<script>
const canvas = document.getElementById('bgAnimation');
const ctx = canvas.getContext('2d');
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;

let particles = [];
for (let i = 0; i < 80; i++) {
    particles.push({
        x: Math.random() * canvas.width,
        y: Math.random() * canvas.height,
        r: Math.random() * 2 + 1
    });
}
function animate() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = 'white';
    particles.forEach(p => {
        ctx.beginPath();
        ctx.arc(p.x, p.y, p.r, 0, Math.PI * 2);
        ctx.fill();
        p.y -= 0.3;
        if (p.y < 0) p.y = canvas.height;
    });
    requestAnimationFrame(animate);
}
animate();
</script>

</body>
</html>

<?php
// ================== db.php ==================
try {
    $host = "localhost";
    $db   = "kkfxoaad_bella";
    $user = "kkfxoaad";
    $pass = "Bitok@2025";
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Connection failed: ' . $e->getMessage()]);
    exit;
}
?>
