<?php
session_start();
require_once 'db.php'; // Updated to use PDO connection

// Only allow admins
if (!isset($_SESSION['user_id']) || ($_SESSION['is_admin'] ?? 0) != 1) {
    header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
    exit();
}

// Get product ID
$id = intval($_GET['id'] ?? 0);
if (!$id) {
    header("Location: admin-products.php");
    exit();
}

try {
    // Fetch image name
    $stmt = $conn->prepare("SELECT image FROM products WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $image = $stmt->fetch(PDO::FETCH_ASSOC);
    $image_name = $image['image'] ?? '';

    // Delete product
    $stmt = $conn->prepare("DELETE FROM products WHERE id = :id");
    $stmt->execute([':id' => $id]);

    // Delete image file if exists
    if (!empty($image_name) && file_exists("uploads/$image_name")) {
        unlink("uploads/$image_name");
    }

} catch (PDOException $e) {
    error_log("Delete Product Error: " . $e->getMessage());
}

// Redirect back to admin-products.php
header("Location: admin-products.php");
exit();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Delete Product - Admin</title>
  <link rel="icon" href="images/taji-yetu.png" type="image/png">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Inter', sans-serif;
      background-color: #000;
      color: #fff;
      margin: 0;
      overflow-x: hidden;
      position: relative;
    }

    canvas#bg {
      position: fixed;
      top: 0;
      left: 0;
      z-index: -1;
      width: 100%;
      height: 100%;
      background: #000;
    }

    main {
      margin-left: 250px;
      padding: 100px 20px;
      min-height: 100vh;
      position: relative;
      z-index: 1;
    }

    .card {
      background: rgba(255,255,255,0.05);
      border: 1px solid rgba(255,255,255,0.1);
      border-radius: 20px;
      padding: 30px;
      backdrop-filter: blur(8px);
      color: #fff;
      text-align: center;
      transition: all 0.3s ease;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 0 20px rgba(255,255,255,0.2);
    }

    @media (max-width: 768px) {
      main {
        margin-left: 0;
        padding: 60px 10px;
      }
      .card { padding: 20px; }
    }
  </style>
</head>
<body>
  <canvas id="bg"></canvas>
  <?php include "navbar.php"; ?>
  <?php include "admin-sidebar.php"; ?>

  <main>
    <div class="container">
      <div class="card mx-auto" style="max-width:600px;">
        <h2>Deleting Product...</h2>
        <p>This page will redirect you shortly.</p>
      </div>
    </div>
  </main>

  <script>
  // Background particles animation
  const canvas = document.getElementById('bg');
  const ctx = canvas.getContext('2d');
  let particles = [];

  function resize() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
  }
  window.addEventListener('resize', resize);
  resize();

  for (let i = 0; i < 80; i++) {
    particles.push({
      x: Math.random() * canvas.width,
      y: Math.random() * canvas.height,
      size: Math.random() * 2 + 1
    });
  }

  function animate() {
    ctx.fillStyle = "#000";
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = "white";
    particles.forEach(p => {
      ctx.beginPath();
      ctx.arc(p.x, p.y, p.size, 0, Math.PI * 2);
      ctx.fill();
      p.y -= 0.3;
      if (p.y < 0) p.y = canvas.height;
    });
    requestAnimationFrame(animate);
  }
  animate();
  </script>
</body>
</html>
