<?php 
session_start();
$isAdmin = $_SESSION['is_admin'] ?? 0;

// Randomized contact info (can later pull from DB/settings)
$contact_phone = "+254 " . rand(700000000, 799999999);
$contact_email = "info" . rand(1,99) . "@tajiyetu.co.ke";
$office_location = "123 Belagids Avenue, Nairobi, Kenya";

// Success/Error messages from session
$successMsg = $_SESSION['contact_success'] ?? '';
$errorMsg   = $_SESSION['contact_error'] ?? '';
unset($_SESSION['contact_success'], $_SESSION['contact_error']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Contact Us - Taji Yetu</title>
  <link rel="icon" href="images/taji-yetu.png" type="image/png">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <?php if ($isAdmin): ?>
    <link rel="stylesheet" href="admin-sidebar.css">
  <?php endif; ?>

  <style>
    body {
      font-family: 'Inter', sans-serif;
      background-color: #000;
      color: #fff;
      margin: 0;
      padding: 0;
      overflow-x: hidden;
    }

    canvas#bgAnimation {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
      background: #000;
    }

    main {
      margin-left: <?= $isAdmin ? '250px' : '0' ?>;
      padding-top: 80px;
      min-height: 100vh;
      background: transparent;
    }

    .page-header {
      background: url("assets/header-bg.jpg") center/cover no-repeat;
      padding: 100px 20px;
      text-align: center;
      color: #fff;
    }

    .page-header h1 {
      font-size: 42px;
      font-weight: bold;
      animation: fadeInDown 1s;
    }

    .page-header .breadcrumb {
      justify-content: center;
      background: transparent;
    }

    .contact-section {
      padding: 60px 20px;
    }

    .contact-card {
      background: #1a1a1a;
      border-radius: 12px;
      padding: 25px;
      text-align: center;
      transition: 0.3s;
      height: 100%;
    }

    .contact-card:hover {
      background: #222;
      transform: translateY(-5px);
    }

    .contact-card i {
      font-size: 32px;
      margin-bottom: 15px;
      color: #ccc;
    }

    .contact-card h4 {
      margin-bottom: 8px;
      color: #fff;
    }

    .contact-card p, .contact-card a {
      color: #aaa;
      font-size: 14px;
    }

    .contact-form {
      background: #1a1a1a;
      border-radius: 12px;
      padding: 30px;
    }

    .contact-form input,
    .contact-form textarea {
      background: #222;
      border: none;
      color: #fff;
      margin-bottom: 15px;
    }

    .contact-form input::placeholder,
    .contact-form textarea::placeholder {
      color: #777;
    }

    .contact-form button {
      background: #28a745;
      border: none;
      padding: 12px 25px;
      color: #fff;
      font-weight: bold;
      border-radius: 6px;
      transition: 0.3s;
    }

    .contact-form button:hover {
      background: #218838;
    }

    .success-msg { color: #28a745; margin-bottom: 10px; }
    .error-msg { color: #c00; margin-bottom: 10px; }

    @keyframes fadeInDown {
      from { opacity: 0; transform: translateY(-30px); }
      to { opacity: 1; transform: translateY(0); }
    }

    @media (max-width: 768px) {
      main {
        margin-left: 0;
        padding-top: 60px;
      }
      .page-header h1 {
        font-size: 28px;
      }
    }
  </style>
</head>
<body>

  <canvas id="bgAnimation"></canvas>

  <?php include "navbar.php"; ?>
  <?php if ($isAdmin) include "admin-sidebar.php"; ?>

  <main>
    <div class="page-header">
      <h1>Contact Us</h1>
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php" class="text-white">Home</a></li>
          <li class="breadcrumb-item active text-secondary">Contact</li>
        </ol>
      </nav>
    </div>

    <section class="contact-section container">
      <div class="row g-4 mb-5 text-center">
        <div class="col-md-4">
          <div class="contact-card">
            <i class="fas fa-map-marker-alt"></i>
            <h4>Visit Us</h4>
            <p><?= htmlspecialchars($office_location) ?></p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="contact-card">
            <i class="fas fa-phone"></i>
            <h4>Call Us</h4>
            <p><?= htmlspecialchars($contact_phone) ?></p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="contact-card">
            <i class="fas fa-envelope"></i>
            <h4>Email</h4>
            <p><?= htmlspecialchars($contact_email) ?></p>
          </div>
        </div>
      </div>

      <div class="row justify-content-center">
        <div class="col-lg-8">
          <div class="contact-form">
            <?php if ($successMsg): ?>
              <div class="success-msg"><?= htmlspecialchars($successMsg) ?></div>
            <?php endif; ?>
            <?php if ($errorMsg): ?>
              <div class="error-msg"><?= htmlspecialchars($errorMsg) ?></div>
            <?php endif; ?>

            <form method="POST" action="contact_submit.php">
              <input type="text" name="name" class="form-control" placeholder="Your Name" required>
              <input type="email" name="email" class="form-control" placeholder="Your Email" required>
              <input type="text" name="subject" class="form-control" placeholder="Subject" required>
              <textarea name="message" class="form-control" rows="5" placeholder="Your Message..." required></textarea>
              <button type="submit">Send Message</button>
            </form>
          </div>
        </div>
      </div>
    </section>
  </main>

  <?php include "footer.php"; ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <script>
  const canvas = document.getElementById('bgAnimation');
  const ctx = canvas.getContext('2d');
  canvas.width = window.innerWidth;
  canvas.height = window.innerHeight;

  const particles = [];
  for (let i = 0; i < 80; i++) {
    particles.push({
      x: Math.random() * canvas.width,
      y: Math.random() * canvas.height,
      r: Math.random() * 2 + 1
    });
  }

  function animate() {
    ctx.fillStyle = 'black';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = 'white';
    particles.forEach(p => {
      ctx.beginPath();
      ctx.arc(p.x, p.y, p.r, 0, Math.PI * 2);
      ctx.fill();
      p.y -= 0.3;
      if (p.y < 0) p.y = canvas.height;
    });
    requestAnimationFrame(animate);
  }
  animate();

  window.addEventListener('resize', () => {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
  });
  </script>
</body>
</html>

<?php
// db.php (PDO version)
$host = 'localhost';
$db   = 'tajiyetu_db';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $conn = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    error_log('Connection failed: ' . $e->getMessage());
    die('Database connection failed.');
}
?>
