<?php
// admin-sidebar.php
?>

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* Sidebar container */
.admin-sidebar {
  width: 250px;
  background: #111;
  color: #fff;
  position: fixed;
  top: 60px; /* below navbar */
  left: 0;
  height: calc(100vh - 60px);
  overflow-y: auto;
  transition: transform 0.3s ease-in-out;
  z-index: 1000;
}

/* Sidebar header */
.admin-sidebar .sidebar-header {
  padding: 20px;
  background: #111;
  border-bottom: 1px solid #222;
}

.admin-sidebar .sidebar-header h3 {
  margin: 0;
  font-size: 18px;
  font-weight: bold;
  color: #fff;
}

/* Sidebar links */
.admin-sidebar ul {
  list-style: none;
  margin: 0;
  padding: 0;
}

.admin-sidebar ul li {
  border-bottom: 1px solid #222;
}

.admin-sidebar ul li a {
  display: flex;
  align-items: center;
  gap: 10px;
  color: #ddd;
  text-decoration: none;
  padding: 14px 20px;
  transition: background 0.3s, color 0.3s;
  font-size: 15px;
}

.admin-sidebar ul li a:hover {
  background: #222;
  color: #fff;
}

.admin-sidebar ul li a i {
  width: 20px;
  text-align: center;
  font-size: 16px;
  color: #bbb;
}

/* Main content */
.main-content {
  margin-left: 250px;
  padding: 20px;
  margin-top: 60px;
  min-height: calc(100vh - 60px);
  transition: margin-left 0.3s ease-in-out;
}

/* Hamburger (sidebar toggle) */
.sidebar-toggle {
  display: none;
  position: fixed;
  top: 70px; /* just below navbar */
  left: 15px;
  background: #111;
  color: #fff;
  border: none;
  padding: 8px 12px;
  font-size: 18px;
  cursor: pointer;
  z-index: 2000 !important;
  border-radius: 4px;
  transition: left 0.3s ease-in-out;
}

/* Move hamburger when sidebar is open */
.admin-sidebar.active ~ .sidebar-toggle {
  left: 265px; /* sidebar width + margin */
}

/* Overlay for mobile when sidebar is open */
.sidebar-overlay {
  display: none;
  position: fixed;
  top: 60px;
  left: 0;
  width: 100%;
  height: calc(100vh - 60px);
  background: rgba(0,0,0,0.5);
  z-index: 900;
}

/* Mobile view */
@media (max-width: 768px) {
  .admin-sidebar {
    transform: translateX(-100%);
  }

  .admin-sidebar.active {
    transform: translateX(0);
  }

  .sidebar-toggle {
    display: block;
  }

  .main-content {
    margin-left: 0 !important;
    width: 100% !important;
  }

  .sidebar-overlay.active {
    display: block;
  }
}
</style>

<!-- Sidebar -->
<div class="admin-sidebar" id="adminSidebar">
  <div class="sidebar-header">
    <h3><i class="fa-solid fa-screwdriver-wrench"></i> Admin Panel</h3>
  </div>
  <ul>
    <li><a href="admin-dashboard.php"><i class="fa-solid fa-gauge-high"></i> Dashboard</a></li>
    <li><a href="admin-products.php"><i class="fa-solid fa-boxes-stacked"></i> Products</a></li>
    <li><a href="admin-orders.php"><i class="fa-solid fa-cart-shopping"></i> Orders</a></li>
    <li><a href="admin-users.php"><i class="fa-solid fa-users"></i> Users</a></li>
    <li><a href="messages.php"><i class="fa-solid fa-envelope"></i> Messages</a></li>
    <li><a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> Logout</a></li>
  </ul>
</div>

<!-- Sidebar toggle -->
<button class="sidebar-toggle" id="sidebarToggle"><i class="fa-solid fa-bars"></i></button>

<!-- Overlay -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>

<script>
const sidebar = document.getElementById('adminSidebar');
const toggle = document.getElementById('sidebarToggle');
const overlay = document.getElementById('sidebarOverlay');

toggle.addEventListener('click', () => {
  sidebar.classList.toggle('active');
  overlay.classList.toggle('active');
});

overlay.addEventListener('click', () => {
  sidebar.classList.remove('active');
  overlay.classList.remove('active');
});
</script>
