<?php
session_start();
require_once 'db.php';

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

try {
    $stmt = $conn->prepare("SELECT is_admin, firstName, lastName FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || $user['is_admin'] != 1) {
        header("Location: index.php");
        exit();
    }

    $firstName = $user['firstName'];
    $lastName = $user['lastName'];
    $displayName = trim(($firstName ?? '') . ' ' . ($lastName ?? ''));
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="icon" href="images/taji-yetu.png" type="image/png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
  <link rel="stylesheet" href="admin-sidebar.css">

  <style>
    * {margin: 0; padding: 0; box-sizing: border-box;}
    body {font-family: 'Poppins', sans-serif; background: #000; color: #fff; overflow-x: hidden;}
    canvas#bg {position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: -1; background: #000;}

    .dashboard-wrapper {
      display: flex;
      min-height: calc(100vh - 60px);
      margin-top: 60px;
      position: relative;
    }

    .main-content {
      margin-left: 250px; /* match sidebar width */
      flex: 1;
      padding: 0;
      background: rgba(0,0,0,0.9);
      color: #fff;
      min-height: calc(100vh - 60px);
      overflow: hidden;
    }

    /* ====== Belagidds Content Inside Main ====== */
    .hero {
      text-align: center;
      padding: 1px 2px 60px;
      background: rgba(0,0,0,0.8);
    }
    .hero h1 {font-size: 3rem; margin-bottom: 15px;}
    .hero p {font-size: 1.2rem; margin-bottom: 25px;}
    .hero button {
      padding: 12px 28px;
      border: none;
      border-radius: 25px;
      background: #fff;
      color: #000;
      cursor: pointer;
      font-weight: bold;
      transition: 0.3s;
    }
    .hero button:hover {background: #ff4d4d; color: #fff;}

    .highlight {
      display: flex;
      justify-content: center;
      align-items: center;
      margin: 60px 20px;
    }
    .highlight-container {
      display: flex;
      align-items: center;
      gap: 20px;
      background: rgba(0,0,0,0.6);
      padding: 20px 25px;
      border-radius: 12px;
      max-width: 800px;
    }
    .highlight-container img {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 10px;
    }
    .highlight-container p {
      font-size: 1.1rem;
      font-weight: bold;
      color: #fff;
      margin: 0;
    }

    .gallery-section {
      background: rgba(0,0,0,0.7);
      padding: 5px 10px 3px;
    }
    .swiper-container {padding: 0 20px;}
    .swiper-slide {display: flex; justify-content: center;}
    .product-slide {
      width: 100%;
      max-width: 240px;
      cursor: pointer;
      overflow: hidden;
      border-radius: 12px;
      transition: transform 0.3s ease;
    }
    .product-slide img {
      width: 100%;
      height: 260px;
      object-fit: cover;
      border-radius: 12px;
      filter: grayscale(100%);
      transition: 0.5s ease;
    }
    .product-slide:hover img {
      filter: grayscale(0%);
      transform: scale(1.05);
    }

    .more-btn {
      display: flex;
      justify-content: center;
      margin-top: 30px;
    }
    .more-btn a {
      background: #fff;
      color: #000;
      padding: 10px 25px;
      border-radius: 25px;
      font-weight: bold;
      text-decoration: none;
      transition: all 0.3s ease;
    }
    .more-btn a:hover {
      background: #ff4d4d;
      color: #fff;
    }

    .bg-image {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
      overflow: hidden;
    }
    .bg-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      opacity: 0.7;
    }

    /* ====== Responsive ====== */
    @media(max-width: 992px) {
      .main-content {margin-left: 0;}
      .highlight-container {flex-direction: column; text-align: center;}
      .highlight-container img {margin-bottom: 12px;}
      .hero h1 {font-size: 2rem;}
      .hero p {font-size: 1rem;}
      .product-slide img {height: 180px;}
    }
  </style>
</head>
<body>

<?php include "navbar.php"; ?>

<div class="dashboard-wrapper">
  <?php include "admin-sidebar.php"; ?>

  <div class="main-content">
    <canvas id="bg"></canvas>
    <div class="bg-image">
      <img src="images/bg.jpg" alt="Model">
    </div>

   <section class="hero">
  <h1>Admin Dashboard</h1>
  <p>Hi <?php echo htmlspecialchars($firstName ?? ''); ?>, welcome!</p>
</section>

    <section class="gallery-section">
      <div class="swiper-container">
        <div class="swiper-wrapper" id="product-slider"></div>
      </div>
      <div class="more-btn">
        <a href="listing.php">Go To Shop</a>
      </div>
    </section>
  </div>
</div>

<?php include "footer.php"; ?>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
let counter=0;
const highlight=document.getElementById("highlight-number");
const interval=setInterval(()=>{if(counter<90){counter++;highlight.textContent=counter+"%";}else{clearInterval(interval);}},40);

async function loadSliderProducts(){
  try{
    const res=await fetch('get-products.php');
    const products=await res.json();
    const slider=document.getElementById('product-slider');
    slider.innerHTML='';
    products.forEach(product=>{
      const slide=document.createElement('div');
      slide.className='swiper-slide';
      slide.innerHTML=`<div class="product-slide" onclick="window.location.href='product.php?id=${product.id}'"><img src="uploads/${product.image}" alt="${product.name}"></div>`;
      slider.appendChild(slide);
    });
    new Swiper('.swiper-container',{
      slidesPerView:4,
      spaceBetween:20,
      loop:true,
      autoplay:{delay:3000,disableOnInteraction:true},
      breakpoints:{0:{slidesPerView:2},768:{slidesPerView:3},1024:{slidesPerView:4}}
    });
  }catch(err){console.error('Slider load failed:',err);}
}
loadSliderProducts();

// Background particles animation
const canvas=document.getElementById('bg');
const ctx=canvas.getContext('2d');
function resize(){canvas.width=window.innerWidth;canvas.height=window.innerHeight;}
window.addEventListener('resize',resize);resize();
let particles=[];
for(let i=0;i<80;i++){particles.push({x:Math.random()*canvas.width,y:Math.random()*canvas.height,r:Math.random()*2+1});}
function animate(){
  ctx.fillStyle="#000";ctx.fillRect(0,0,canvas.width,canvas.height);
  ctx.fillStyle="white";
  particles.forEach(p=>{ctx.beginPath();ctx.arc(p.x,p.y,p.r,0,Math.PI*2);ctx.fill();p.y-=0.3;if(p.y<0)p.y=canvas.height;});
  requestAnimationFrame(animate);
}
animate();
</script>

<script src="admin-sidebar.js"></script>
</body>
</html>
