<?php
session_start();
$is_admin = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>About — Taji Yetu</title>

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Animate.css for entry animations -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

  <!-- Sidebar CSS -->
  <link rel="stylesheet" href="admin-sidebar.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

  <style>
    :root {
      --bg: #000;
      --muted: #bdbdbd;
      --white: #ffffff;
      --glass-alpha: 0.06;
      --accent-blue: #007bff;
      --accent-orange: #fd7e14;
      --max-width: 1200px;
      --gap: 24px;
      --radius: 12px;
    }

    * { box-sizing: border-box; }
    html, body { height: 100%; margin: 0; scroll-behavior: smooth; }
    body {
      background: var(--bg);
      color: var(--white);
      font-family: 'Inter', system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      line-height: 1.6;
    }
    a { color: inherit; text-decoration: none; transition: 0.3s; }
    a:hover { opacity: 0.8; }
    img { max-width: 100%; display: block; height: auto; }

    .page { position: relative; min-height: 100vh; overflow-x: hidden; }

    /* background animations */
    .bg-animations {
      position: fixed; inset: 0; pointer-events: none; z-index: 0; opacity: 0.65; mix-blend-mode: screen;
    }
    .bg-animations .shape {
      position: absolute; border-radius: 22%;
      background: linear-gradient(135deg, rgba(255,255,255,0.05), rgba(255,255,255,0.02));
      filter: blur(18px);
      animation: floatY 10s ease-in-out infinite;
    }
    .bg-animations .s1{ left:6%; top:8%; width:220px; height:220px; animation-delay:0s;}
    .bg-animations .s2{ right:6%; top:18%; width:140px; height:140px; animation-delay:2s;}
    .bg-animations .s3{ left:12%; bottom:8%; width:160px; height:160px; animation-delay:4s;}
    .bg-animations .s4{ right:18%; bottom:12%; width:200px; height:200px; animation-delay:6s;}
    @keyframes floatY {
      0% { transform:translateY(0) rotate(0deg) }
      50% { transform:translateY(-18px) rotate(6deg) }
      100% { transform:translateY(0) rotate(0deg) }
    }
    .bg-lines { position: fixed; inset:0; z-index:0; pointer-events:none; }
    .bg-lines svg { width:100%; height:100%; opacity:0.08; }

    /* layout */
    .dashboard-wrapper {
      display: flex;
      min-height: calc(100vh - 60px);
      margin-top: 60px;
      max-width: var(--max-width);
      margin-left: auto;
      margin-right: auto;
      position: relative;
      z-index: 2;
    }
    .main-content {
      flex: 1;
      padding: 28px 20px 80px;
    }

    /* hero section */
    .hero {
      display: flex;
      flex-direction: column;
      gap: 18px;
      align-items: flex-start;
      padding: 40px;
      background: linear-gradient(180deg, rgba(255,255,255,var(--glass-alpha)), rgba(255,255,255,0.02));
      border-radius: var(--radius);
      border: 1px solid rgba(255,255,255,0.04);
      box-shadow: 0 6px 30px rgba(0,0,0,0.6);
      position: relative;
      overflow: hidden;
    }

    .eyebrow { font-size: 13px; color: var(--muted); text-transform: uppercase; font-weight: 600; letter-spacing: 1px; }
    .hero-title { font-size: clamp(28px, 4.5vw, 46px); font-weight: 700; margin: 0; }
    .hero-sub { color: var(--muted); max-width: 820px; font-size: 15px; margin-top: 6px; }

    .btn {
      display: inline-flex; align-items: center; justify-content: center; gap: 8px;
      padding: 10px 16px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 14px;
      color: var(--white);
      cursor: pointer;
      border: 0;
      transition: all 0.3s ease;
    }
    .btn-blue { background: var(--accent-blue); }
    .btn-orange { background: var(--accent-orange); }
    .btn:hover { transform: translateY(-2px); }

    /* story content */
    .story-text h2 {
      margin-top: 20px;
      font-size: 22px;
      display: flex;
      align-items: center;
      gap: 10px;
      color: var(--white);
      border-left: 3px solid var(--accent-orange);
      padding-left: 10px;
    }
    .story-text p {
      color: var(--muted);
      margin: 10px 0 16px;
      font-size: 15px;
      line-height: 1.7;
    }
    .story-text em {
      color: var(--accent-orange);
      font-style: normal;
      font-weight: 600;
    }

    .brand-visual {
      margin-top: 30px;
      display: flex;
      gap: 18px;
      align-items: center;
      font-size: 14px;
      color: var(--muted);
    }
    .brand-visual i { color: var(--accent-orange); }

    /* responsive */
    @media(min-width:880px){
      .grid { grid-template-columns: 1fr 360px; align-items: start; }
    }
    @media(max-width:768px){
      .dashboard-wrapper { flex-direction: column; margin-top: 60px; }
      .sidebar { display: none; }
      .hero { padding: 24px; }
    }
  </style>
</head>
<body>
  <div class="page">
    <!-- background -->
    <div class="bg-animations" aria-hidden="true">
      <div class="shape s1"></div><div class="shape s2"></div><div class="shape s3"></div><div class="shape s4"></div>
    </div>
    <div class="bg-lines" aria-hidden="true">
      <svg viewBox="0 0 100 100" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
        <defs><linearGradient id="g" x1="0" x2="1">
          <stop offset="0" stop-color="#fff" stop-opacity="0.06"/>
          <stop offset="1" stop-color="#fff" stop-opacity="0.02"/>
        </linearGradient></defs>
        <path d="M0 100 L100 0" stroke="url(#g)" stroke-width="0.8" stroke-linecap="round"></path>
        <path d="M0 75 L75 0" stroke="url(#g)" stroke-width="0.6" stroke-linecap="round"></path>
        <path d="M25 100 L100 25" stroke="url(#g)" stroke-width="0.6" stroke-linecap="round"></path>
      </svg>
    </div>

    <?php include 'navbar.php'; ?>

    <div class="dashboard-wrapper">
      <?php if ($is_admin): ?>
        <div class="sidebar"><?php include 'admin-sidebar.php'; ?></div>
      <?php endif; ?>

      <main class="main-content" role="main" aria-labelledby="about-heading">

        <!-- HERO SECTION -->
        <section class="hero animate__animated animate__fadeInUp" aria-labelledby="about-heading">
          <div class="eyebrow"><i class="fas fa-circle-info"></i> About</div>
          <h1 id="about-heading" class="hero-title">Taji Yetu</h1>
          <p class="hero-sub">Why We Wear Black — and why, as a Belagid, you might choose to embrace this timeless dress code.</p>

          <div class="hero-ctas animate__animated animate__fadeIn animate__delay-1s">
            <a class="btn btn-orange" href="listing.php">
              <i class="fas fa-shopping-bag"></i> Continue Shopping
            </a>
          </div>

          <!-- Refined About Content -->
          <div class="story-text animate__animated animate__fadeInUp animate__delay-1s" style="margin-top:24px;">
            <h2><i class="fas fa-circle-half-stroke"></i> Why We Wear Black</h2>
            <p>
              For centuries, people across the world have referred to the people of the Motherland simply as “Black.”
              This has led to the widespread assumption that we are all of one color. In truth, the Motherland is one of
              the most genetically diverse places on Earth. Within our lands you will find every possible skin tone —
              from soft ivory and golden caramel to deep chocolate and rich clay.
            </p>
            <p>
              As Belagids, our monochrome dress is not just a style choice — it is a statement. By wearing black and white,
              we remove distractions so that attention is drawn to our skin — our natural diversity and beauty. It is our
              way of showing the world that we are not one color; we are many — each unique, each radiant.
            </p>

            <h2 style="margin-top:28px;"><i class="fas fa-hand-holding-heart"></i> Why You Should Embrace This Dress Code</h2>
            <p>
              During colonization, our ancestors were stripped of their clothing, jewelry, and adornments — deliberate
              acts meant to erase their identity and culture. In many African societies, attire is not mere decoration;
              it is a language of belonging, pride, and continuity.
            </p>
            <p>
              Just as a Maasai’s traditional garments identify them as part of a community, so too does our Belagid
              dress connect us to our roots. When we replace our cultural markers with generic fashion, we risk appearing
              like people without identity — disconnected from our lineage.
            </p>
            <p>
              By adopting this dress code in your daily life, you reclaim that identity. You tell the world,
              <em>“I know who I am, and I wear it proudly.”</em>
            </p>
          </div>

          <div class="brand-visual animate__animated animate__fadeInUp animate__delay-2s" aria-hidden="true">
            <img src="images/taji-yetu.png" alt="Taji Yetu Logo" style="width:64px;height:auto;">
            <div class="brand-text">
              <i class="fas fa-gem"></i> Taji Yetu — Nairobi-born, globally inspired. Rooted in craft, driven by style.
            </div>
          </div>
        </section>

        <section style="margin-top:40px;" class="animate__animated animate__fadeInUp animate__delay-2s">
          <h3><i class="fas fa-user"></i> Meet the Founder</h3>
          <p style="color:var(--muted); max-width:720px;">
            Amina Ndungu — designer & founder. Amina trained in tailoring and product design and started Taji Yetu to make considered fashion that fits modern life and honors African identity.
          </p>
        </section>

        <div style="margin-top:32px; color:var(--muted); font-size:13px;">
          <p>Questions about fit or custom orders?
            <a href="contactus.php" style="color:var(--white); text-decoration:underline">
              Contact our team
            </a>.
          </p>
        </div>
      </main>
    </div>

    <?php include 'footer.php'; ?>
  </div>

  <script>
    // Reduce motion for smaller screens or users with reduced motion preferences
    (function(){
      function reduceMotion() {
        if (window.matchMedia('(max-width:600px)').matches || window.matchMedia('(prefers-reduced-motion: reduce)').matches) {
          document.querySelectorAll('.bg-animations .shape').forEach(s => {
            s.style.opacity = '0.45';
            s.style.filter = 'blur(12px)';
            s.style.animationDuration = '18s';
          });
          document.querySelectorAll('.bg-lines svg').forEach(svg => svg.style.opacity = '0.04');
        }
      }
      reduceMotion();
      window.addEventListener('resize', reduceMotion);
    })();

    // Scroll-based animation triggers
    document.addEventListener("DOMContentLoaded", function() {
      const animatedEls = document.querySelectorAll('.animate__animated');
      const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
          if (entry.isIntersecting) entry.target.classList.add('animate__fadeInUp');
        });
      }, { threshold: 0.15 });
      animatedEls.forEach(el => observer.observe(el));
    });
  </script>
</body>
</html>
