<?php
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

$slug = $_GET['slug'] ?? '';
$stmt = $conn->prepare("SELECT * FROM products WHERE slug = ?");
$stmt->bind_param("s", $slug);
$stmt->execute();
$result = $stmt->get_result();
$product = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= $product ? $product['name'] : 'Product Not Found' ?> - Taji Yetu</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #000;
      color: #fff;
    }

    /* Header styles (same as yours) */
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 30px;
      background-color: rgba(17, 17, 17, 0.8);
      position: relative;
    }

    .header-left {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .logo img {
      height: 40px;
    }

    .belagidds-btn {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .header-right {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .cart-icon {
      font-size: 1.3rem;
      cursor: pointer;
      color: #fff;
    }

    .account-dropdown {
      position: relative;
    }

    .account-button {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background-color: #222;
      border: 1px solid #333;
      border-radius: 5px;
      overflow: hidden;
      z-index: 10;
    }

    .dropdown-menu a {
      display: block;
      color: #fff;
      text-decoration: none;
      padding: 10px 15px;
      transition: background 0.3s;
    }

    .dropdown-menu a:hover {
      background-color: #333;
    }

    .account-dropdown:hover .dropdown-menu {
      display: block;
    }

    /* Product section */
    .product-container {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-align: center;
      padding: 40px 20px;
    }

    .product-container img {
      max-width: 300px;
      border-radius: 10px;
      margin-bottom: 20px;
    }

    .product-container h1 {
      font-size: 28px;
      margin-bottom: 10px;
    }

    .product-container p {
      font-size: 20px;
      margin-bottom: 20px;
    }

    .buttons {
      display: flex;
      gap: 20px;
    }

    .buy-btn, .shop-btn {
      background: #fff;
      color: #000;
      border: none;
      padding: 10px 20px;
      font-weight: bold;
      border-radius: 5px;
      cursor: pointer;
      transition: background 0.3s;
    }

    .buy-btn:hover, .shop-btn:hover {
      background: #ccc;
    }

    /* Footer */
    footer {
      background-color: rgba(17, 17, 17, 0.8);
      padding: 30px 20px;
      text-align: center;
    }

    .social-icons {
      margin-bottom: 15px;
    }

    .social-icons a {
      color: #fff;
      font-size: 1.4rem;
      margin: 0 10px;
      transition: color 0.3s;
    }

    .social-icons a:hover {
      color: #888;
    }

    .copyright {
      font-size: 0.9rem;
      color: #aaa;
    }
  </style>
</head>
<body>

  <!-- Header -->
  <header>
    <div class="header-left">
      <a href="/Bella/index.php" class="logo"><img src="/Bella/images/TAJI YETU.PNG" alt="Logo"></a>
      <button class="belagidds-btn">Belagidds</button>
    </div>

    <div class="header-right">
      <a href="add-to-cart.php?id=<?= $product['id'] ?>"><button class="buy-btn">Add to Cart</button></a>

      <div class="account-dropdown">
        <button class="account-button">Account <i class="fas fa-caret-down"></i></button>
        <div class="dropdown-menu">
          <a href="/Bella/profile.php">Profile</a>
          <a href="/Bella/orders.php">Orders</a>
          <a href="/Bella/logout.php">Logout</a>
        </div>
      </div>
    </div>
  </header>

  <!-- Product Details -->
  <div class="product-container">
    <?php if ($product): ?>
      <img src="/Bella/uploads/<?= htmlspecialchars($product['image']) ?>" alt="<?= htmlspecialchars($product['name']) ?>">
      <h1><?= htmlspecialchars($product['name']) ?></h1>
      <p>Price: Ksh <?= number_format($product['price']) ?></p>
      <div class="buttons">
        <button class="buy-btn" onclick="window.location.href='/Bella/add-to-cart.php?id=<?= $product['id'] ?>'">Add to Cart</button>
        <button class="shop-btn" onclick="window.location.href='/Bella/listing.html'">Continue Shopping</button>
      </div>
    <?php else: ?>
      <h2>Product not found.</h2>
    <?php endif; ?>
  </div>
  <script>
  function addToCart(product) {
    let cart = JSON.parse(localStorage.getItem("cart")) || [];
    const existingIndex = cart.findIndex(item => item.id === product.id);

    if (existingIndex !== -1) {
      cart[existingIndex].quantity += 1;
    } else {
      product.quantity = 1;
      cart.push(product);
    }

    localStorage.setItem("cart", JSON.stringify(cart));
    alert("Added to cart!");
  }
</script>

</body>
  <!-- Footer -->
  <footer>
    <div class="social-icons">
      <a href="#"><i class="fab fa-facebook-f"></i></a>
      <a href="#"><i class="fab fa-twitter"></i></a>
      <a href="#"><i class="fab fa-instagram"></i></a>
      <a href="#"><i class="fab fa-tiktok"></i></a>
    </div>
    <div class="copyright">
      &copy; 2025 TAJI YETU. All rights reserved.
    </div>
  </footer>


</html>
