<?php
session_start();

// Step 1: Save referring page automatically if not login.php
if (empty($_SESSION['redirect_after_login']) && isset($_SERVER['HTTP_REFERER'])) {
  $referer = basename(parse_url($_SERVER['HTTP_REFERER'], PHP_URL_PATH));
  if ($referer !== 'login.php') {
    $_SESSION['redirect_after_login'] = $_SERVER['HTTP_REFERER'];
  }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

  if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
  }

  $email = trim($_POST['email']);
  $password = $_POST['password'];

  $stmt = $conn->prepare("SELECT id, firstName, lastName, phone, password FROM users WHERE email = ?");
  $stmt->bind_param("s", $email);
  $stmt->execute();
  $stmt->store_result();

  if ($stmt->num_rows > 0) {
    $stmt->bind_result($id, $firstName, $lastName, $phone, $hashedPassword);
    $stmt->fetch();

    if (password_verify($password, $hashedPassword)) {
      // Set session variables
      $_SESSION['user_id'] = $id;
      $_SESSION['name'] = $firstName . ' ' . $lastName;
      $_SESSION['phone'] = $phone;
      $_SESSION['email'] = $email;
      $_SESSION['last_activity'] = time();
      $_SESSION['user'] = $id;

      // Step 2: Redirect to original page
      $redirect = $_SESSION['redirect_after_login'] ?? 'index.php';
      unset($_SESSION['redirect_after_login']);

      header("Location: $redirect");
      exit();
    } else {
      $error = "Incorrect password.";
    }
  } else {
    $error = "No account found with that email.";
  }

  $stmt->close();
  $conn->close();
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login - Taji Yetu</title>
  <link href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:wght@700&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/1.png') center/cover no-repeat fixed;
      margin: 0;
      padding: 0;
      color: #fff;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }

    .container {
      background: rgba(0,0,0,0.85);
      padding: 30px;
      border-radius: 12px;
      width: 100%;
      max-width: 400px;
      box-shadow: 0 0 10px rgba(0,0,0,0.5);
      animation: fadeIn 0.7s ease-out forwards;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(40px); }
      to { opacity: 1; transform: translateY(0); }
    }

    h2 {
      text-align: center;
      margin-bottom: 25px;
    }

    form {
      display: flex;
      flex-direction: column;
    }

    label {
      font-size: 14px;
      margin-bottom: 6px;
    }

    input[type="email"],
    input[type="password"] {
      padding: 10px;
      margin-bottom: 20px;
      border-radius: 6px;
      border: none;
      font-family: 'Old Standard TT', serif;
    }

    input:focus {
      outline: none;
      box-shadow: 0 0 5px #fff;
    }

    button {
      background: #fff;
      color: #000;
      padding: 12px;
      border-radius: 8px;
      font-weight: bold;
      cursor: pointer;
      border: none;
      transition: background 0.3s;
    }

    button:hover {
      background: #ccc;
    }

    p {
      text-align: center;
      margin-top: 15px;
    }

    a {
      color: #ccc;
      text-decoration: underline;
    }

    .error {
      color: #ff8080;
      text-align: center;
      margin-bottom: 15px;
      font-size: 14px;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Login to Your Account</h2>

    <?php if (!empty($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" action="login.php">
      <label for="email">Email</label>
      <input type="email" name="email" required />

      <label for="password">Password</label>
      <input type="password" name="password" required />

      <button type="submit">Login</button>
    </form>

    <p>Don't have an account? <a href="register.html">Register here</a></p>
  </div>
</body>
</html>
