<?php
require_once 'require_login.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Products - Taji Yetu</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #000;
      color: #fff;
    }

    /* Header */
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 30px;
      background-color: rgba(17, 17, 17, 0.8);
      position: relative;
    }

    .header-left {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .logo img {
      height: 40px;
    }

    .belagidds-btn {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .header-right {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .cart-icon {
      font-size: 1.3rem;
      cursor: pointer;
      color: #fff;
    }

    .account-dropdown {
      position: relative;
    }

    .account-button {
      background: #444;
      color: #fff;
      border: none;
      padding: 8px 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background-color: #222;
      border: 1px solid #333;
      border-radius: 5px;
      overflow: hidden;
      z-index: 10;
    }

    .dropdown-menu a {
      display: block;
      color: #fff;
      text-decoration: none;
      padding: 10px 15px;
      transition: background 0.3s;
    }

    .dropdown-menu a:hover {
      background-color: #333;
    }

    .account-dropdown:hover .dropdown-menu {
      display: block;
    }

    /* Masonry Layout */
    .masonry {
      column-count: 2;
      column-gap: 1em;
      padding: 20px;
    }

    @media (min-width: 768px) {
      .masonry {
        column-count: 3;
      }
    }

    @media (min-width: 1024px) {
      .masonry {
        column-count: 4;
      }
    }

    .item {
      background: rgba(255, 255, 255, 0.05);
      border-radius: 10px;
      margin-bottom: 1em;
      display: inline-block;
      width: 100%;
      overflow: hidden;
      break-inside: avoid;
    }

    .item img {
      width: 100%;
      display: block;
      object-fit: cover;
      filter: grayscale(100%);
      transition: 0.3s ease;
    }

    .item:hover img {
      filter: grayscale(0%);
      transform: scale(1.02);
    }

    .info {
      padding: 15px;
      text-align: center;
    }

    .product-name {
      font-size: 16px;
      margin-bottom: 5px;
    }

    .product-price {
      font-size: 14px;
      color: #ccc;
      margin-bottom: 10px;
    }

    .buy-button {
      padding: 8px 16px;
      background: #fff;
      color: #000;
      border: none;
      font-weight: bold;
      border-radius: 5px;
      cursor: pointer;
      transition: background 0.3s;
    }

    .buy-button:hover {
      background: #ccc;
    }

    /* Footer */
    footer {
      background-color: rgba(17, 17, 17, 0.8);
      padding: 30px 20px;
      text-align: center;
    }

    .social-icons {
      margin-bottom: 15px;
    }

    .social-icons a {
      color: #fff;
      font-size: 1.4rem;
      margin: 0 10px;
      transition: color 0.3s;
    }

    .social-icons a:hover {
      color: #888;
    }

    .copyright {
      font-size: 0.9rem;
      color: #aaa;
    }
    /*Cart wrapper  */
    .cart-wrapper {
  position: relative;
  display: inline-block;
  color: #fff;
}

.cart-badge {
  position: absolute;
  top: -8px;
  right: -10px;
  background: red;
  color: white;
  font-size: 8px;
  font-weight: bold;
  border-radius: 20%;
  padding: 3px 6px;
  min-width: 4px;
  text-align: center;
}

  </style>
</head>
<body>

  <!-- Header -->
  <!-- Header -->
<header>
  <div class="header-left">
    <a href="/Bella/index.php" class="logo"><img src="/Bella/images/TAJI YETU.png" alt="Logo"></a>
    <button class="belagidds-btn">Belagidds</button>
  </div>

  <div class="header-right">
    <a href="/Bella/cart.php" class="cart-wrapper">
  <i class="fas fa-shopping-cart cart-icon"></i>
  <?php
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
      foreach ($_SESSION['cart'] as $item) {
        $cart_count += $item['quantity'];
      }
    }
  ?>
  <span class="cart-badge"><?= $cart_count ?></span>
</a>

    <div class="account-dropdown">
      <button class="account-button">
        <?php if (isset($_SESSION['user_id'])): ?>
          <?= htmlspecialchars($_SESSION['name']) ?>
        <?php else: ?>
          Account
        <?php endif; ?>
        <i class="fas fa-caret-down"></i>
      </button>

      <div class="dropdown-menu">
        <?php if (isset($_SESSION['user_id'])): ?>
          <a href="/Bella/profile.php">Profile</a>
          <a href="/Bella/orders.php">Orders</a>
          <a href="/Bella/logout.php">Logout</a>
        <?php else: ?>
          <a href="/Bella/login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>

  <!-- Product Listing -->
  <section class="masonry" id="product-list"></section>
<script>
fetch('get-products.php')
  .then(response => response.json())
  .then(data => {
    const container = document.getElementById('product-list');
    container.innerHTML = '';

    data.forEach(product => {
      const item = document.createElement('div');
      item.classList.add('item');

      item.innerHTML = `
        <img src="uploads/${product.image}" alt="${product.name}">
        <div class="info">
          <div class="product-name">${product.name}</div>
          <div class="product-price">Ksh ${Number(product.price).toLocaleString()}</div>
          <!-- Use query string instead of pretty URL -->
          <button class="buy-button" onclick="window.location.href='product.php?slug=${product.slug}'">Buy Now</button>
        </div>
      `;

      container.appendChild(item);
    });
  })
  .catch(error => {
    console.error('Error loading products:', error);
  });
</script>




<!-- Footer -->
  <footer>
    <div class="social-icons">
    <a href="https://www.facebook.com/share/19B3wm2Xdn/"><i class="fab fa-facebook-f"></i></a>
      <a href="https://x.com/BellaGidds?t=XuTmK5KeSViKkiYy-dhCHw&s=09"><i class="fab fa-twitter"></i></a>
      <a href="https://www.instagram.com/belagids?igsh=MThsZ21xNXB2cXBrYg=="><i class="fab fa-instagram"></i></a>
      <a href="https://www.tiktok.com/@belagids?_t=ZM-8y36Xmrl6Jy&_r=1"><i class="fab fa-tiktok"></i></a>
    </div>
    <div class="copyright">
      &copy; 2025 TAJI YETU. All rights reserved.
    </div>
  </footer>

</body>
</html>
