<?php
session_start();
require_once "db.php";

// Only admin can view
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    die("Unauthorized access");
}

// Get order ID
$order_id = intval($_GET['id'] ?? 0);
if (!$order_id) {
    die("Invalid order ID");
}

// Fetch order info
$stmt = $conn->prepare("SELECT o.id, o.status, o.total_price, o.created_at, u.name AS customer_name, u.email AS customer_email 
                        FROM orders o 
                        JOIN users u ON o.user_id = u.id 
                        WHERE o.id = ?");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) {
    die("Order not found");
}

// Fetch order items
$stmt = $conn->prepare("SELECT p.name, p.image, oi.qty, oi.price 
                        FROM order_items oi 
                        JOIN products p ON oi.product_id = p.id 
                        WHERE oi.order_id = ?");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>View Order #<?= $order['id'] ?></title>
<link href="css/bootstrap.min.css" rel="stylesheet">
<link href="css/bootstrap-icons.css" rel="stylesheet">
<link href="css/tooplate-mini-finance.css" rel="stylesheet">
</head>
<body>

<?php include "navbar.php"; ?>
<?php include "sidebar.php"; ?>

<main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">Order #<?= $order['id'] ?></h1>
        <p>Placed on <?= date("F j, Y, g:i A", strtotime($order['created_at'])) ?></p>
        <p>Customer: <?= htmlspecialchars($order['customer_name']) ?> (<?= htmlspecialchars($order['customer_email']) ?>)</p>
        <p>Status: <strong><?= $order['status'] ?></strong></p>
    </div>

    <div class="table-responsive mb-4">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Image</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($items as $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['name']) ?></td>
                    <td><img src="uploads/<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>" style="width:60px;height:60px;object-fit:cover;"></td>
                    <td><?= $item['qty'] ?></td>
                    <td>Ksh <?= number_format($item['price']) ?></td>
                    <td>Ksh <?= number_format($item['price'] * $item['qty']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <h4>Total Price: Ksh <?= number_format($order['total_price']) ?></h4>

    <a href="admin-orders.php" class="btn btn-secondary mt-3">Back to Orders</a>
</main>

<?php include "footer.php"; ?>
<script src="js/bootstrap.bundle.min.js"></script>
</body>
</html>
