<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

// Fetch logged-in admin info
$adminId = $_SESSION['user_id'];
$isAdmin = $_SESSION['is_admin'] ?? 0;

// Fetch all users
$result = $conn->query("SELECT * FROM users ORDER BY created_at DESC");
$users = [];
$totalAdmins = 0;
$totalUsers = 0;
while ($row = $result->fetch_assoc()) {
    $users[] = $row;
    if ($row['is_admin'] == 1) $totalAdmins++;
    else $totalUsers++;
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Management - Taji Yetu</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="admin-sidebar.css">
<style>
/* Wrapper */
.dashboard-wrapper { display:flex; flex-direction: column; min-height:100vh; margin-top:60px; }
.dashboard-inner { display:flex; flex:1; }

/* Sidebar + main content */
.main-content { flex:1; padding:20px; background:#111; color:#fff; margin-left:250px; }

/* Header */
.main-content h2 { margin-bottom:20px; }

/* Stats circles */
.stats { display:flex; gap:20px; margin-bottom:25px; }
.stats .stat { flex:1; background:#222; text-align:center; padding:20px; border-radius:50%; font-size:1.1rem; }
.stats .stat h3 { margin:0; font-size:1.5rem; color:#fff; }
.stats .stat p { margin:5px 0 0; color:#aaa; }

/* Table */
table { width:100%; border-collapse:collapse; background:#1a1a1a; }
th, td { padding:10px; border:1px solid #333; text-align:left; color:#fff; }
th { background:#222; }
img.profile-pic { width:50px; height:50px; object-fit:cover; border-radius:50%; }

/* Buttons */
button, a.btn { padding:6px 12px; border:none; border-radius:6px; cursor:pointer; font-weight:bold; color:#fff; text-decoration:none; }
button.edit { background:#28a745; }
button.delete, a.delete { background:#c00; }
button.promote { background:#007bff; }
button.demote { background:#007bff; }
button:hover, a.btn:hover { opacity:0.85; }

/* Responsive */
@media(max-width:768px){
  .main-content { margin-left:0; }
  .stats { flex-direction:column; }
  table, th, td { font-size:13px; }
}
</style>
</head>
<body>

<?php include "navbar.php"; ?>

<div class="dashboard-wrapper">
  <?php if ($isAdmin == 1) include "admin-sidebar.php"; ?>

  <div class="dashboard-inner">
    <div class="main-content">
      <h2>Hi Admin, Welcome to User Management!</h2>

      <!-- Stats -->
      <div class="stats">
        <div class="stat"><h3><?= $totalAdmins ?></h3><p>Admins</p></div>
        <div class="stat"><h3><?= $totalUsers ?></h3><p>Users</p></div>
        <div class="stat"><h3><?= $totalAdmins + $totalUsers ?></h3><p>Total</p></div>
      </div>

      <!-- Users Table -->
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Profile</th>
            <th>First Name</th>
            <th>Last Name</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Role</th>
            <th>Created</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($users as $u): ?>
            <tr>
              <td><?= $u['id'] ?></td>
              <td><img src="<?= $u['profile_pic'] ?: 'images/brain waves.jpg' ?>" class="profile-pic" alt="Profile"></td>
              <td><?= htmlspecialchars($u['firstName']) ?></td>
              <td><?= htmlspecialchars($u['lastName']) ?></td>
              <td><?= htmlspecialchars($u['phone']) ?></td>
              <td><?= htmlspecialchars($u['email']) ?></td>
              <td><?= $u['is_admin'] == 1 ? 'Admin' : 'User' ?></td>
              <td><?= $u['created_at'] ?></td>
              <td>
                <?php if($u['id'] != $adminId): ?>
                  <?php if($u['is_admin']==0): ?>
                    <button class="promote">Promote</button>
                  <?php else: ?>
                    <button class="demote">Demote</button>
                  <?php endif; ?>
                  <button class="edit">Edit</button>
                  <a href="delete-user.php?id=<?= $u['id'] ?>" class="delete">Delete</a>
                <?php else: ?>
                  <span style="color:#777;">Self</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include "footer.php"; ?>

</body>
</html>
