<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

// Check if user is admin
$adminStmt = $conn->prepare("SELECT is_admin, firstName, lastName FROM users WHERE id = ?");
$adminStmt->bind_param("i", $userId);
$adminStmt->execute();
$adminStmt->bind_result($is_admin, $firstName, $lastName);
$adminStmt->fetch();
$adminStmt->close();

if ($is_admin != 1) {
    header("Location: index.php");
    exit();
}
$displayName = trim(($firstName ?? '') . " " . ($lastName ?? ''));

// Cart count
$cart_count = 0;
if (isset($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $item) $cart_count += $item['quantity'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Testingz</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
* { box-sizing: border-box; margin:0; padding:0; }
body {
    font-family: 'Segoe UI', sans-serif;
    background: url('images/bg.jpg') center/cover no-repeat fixed;
    color:#fff;
    display:flex;
    flex-direction:column;
    min-height:100vh;
    padding-bottom:80px;
}

/* Header */
header {
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:15px 30px;
    background-color:#000;
    position:sticky;
    top:0;
    z-index:1000;
    flex-wrap:wrap;
}
.logo img { height:40px; }

/* Center nav */
.header-center { text-align:center; flex:1; }
nav { display:flex; gap:20px; justify-content:center; }
nav a {
    color:#fff;
    text-decoration:none;
    font-weight:500;
    transition:0.3s;
}
nav a:hover { color:#aaa; }

/* Right-side nav & cart */
.header-right { display:flex; align-items:center; gap:20px; }
.cart-wrapper { position:relative; display:inline-block; }
.cart-icon { font-size:1.3rem; cursor:pointer; }
.cart-badge {
    position:absolute; top:-8px; right:-10px;
    background:red; color:#fff;
    font-size:10px; font-weight:bold;
    border-radius:50%; padding:3px 6px;
}
.account-dropdown { position:relative; }
.account-button {
    background:#222; color:#fff;
    border:none; padding:8px 16px;
    border-radius:20px; cursor:pointer;
}
.dropdown-menu {
    display:none; position:absolute;
    right:0; top:100%;
    background:#222; border:1px solid #333;
    border-radius:5px; overflow:hidden;
    z-index:10;
}
.dropdown-menu a {
    display:block; color:#fff;
    text-decoration:none; padding:10px 15px;
    transition: background 0.3s;
}
.dropdown-menu a:hover { background:#333; }
.account-dropdown:hover .dropdown-menu { display:block; }

/* Hero Section */
.hero { display:flex; justify-content:center; align-items:center; padding:80px 20px 20px; }
.overlay-text {
    display:flex; align-items:center; gap:20px;
    background: rgba(0,0,0,0.7); padding:20px; border-radius:10px; max-width:90%; flex-wrap:wrap;
}
.overlay-text img { width:100px; height:auto; border-radius:8px; flex-shrink:0; }
.overlay-text .text-content { flex:1; font-size:22px; line-height:1.4; }


/* Footer */
footer {
    background-color: rgba(17,17,17,0.8);
    padding:20px 20px;
    text-align:center;
    position:fixed;
    bottom:0;
    width:100%;
    z-index:999;
}
.social-icons { margin-bottom:10px; }
.social-icons a { color:#fff; font-size:1.4rem; margin:0 10px; transition:color 0.3s; }
.social-icons a:hover { color:#ccc; }
.copyright { font-size:0.9rem; color:#aaa; }

/* Hamburger for mobile */
.hamburger { display:none; flex-direction:column; gap:5px; cursor:pointer; }
.hamburger div { width:25px; height:3px; background:#fff; }
@media(max-width:768px) { .hamburger { display:flex; } }
</style>
</head>
<body>

<header>
    <a href="index.php" class="logo"><img src="images/TAJI YETU.png" alt="Logo"></a>

    <div class="header-center">
        <nav>
            <a href="user_management.php">User Management</a>
            <a href="listing.php">Products</a>
            <a href="index.php">About</a>
            <a href="index.php">Contact</a>
        </nav>
    </div>

    <div class="header-right">
        <a href="cart.php" class="cart-wrapper">
            <i class="fas fa-shopping-cart cart-icon"></i>
            <span class="cart-badge"><?= $cart_count ?></span>
        </a>

        <div class="account-dropdown">
            <button class="account-button"><?= htmlspecialchars($displayName ?: 'Admin') ?></button>
            <div class="dropdown-menu">
                <a href="profile.php">Profile</a>
                <a href="login.php">Logout</a>
            </div>
        </div>
    </div>
</header>


<footer>
    <div class="social-icons">
        <a href="#"><i class="fab fa-facebook-f"></i></a>
        <a href="#"><i class="fab fa-twitter"></i></a>
        <a href="#"><i class="fab fa-instagram"></i></a>
        <a href="#"><i class="fab fa-tiktok"></i></a>
    </div>
    <div class="copyright">&copy; 2025 Taji Yetu. All rights reserved.</div>
</footer>

<script>
document.querySelector('.hamburger')?.addEventListener('click', () => {
    document.querySelector('nav')?.classList.toggle('active');
});
</script>

</body>
</html>
