<?php
session_start();
// Connect to database
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get product slug from query string
$slug = $_GET['slug'] ?? '';

// Prepare and execute query safely
$stmt = $conn->prepare("SELECT * FROM products WHERE slug = ?");
$stmt->bind_param("s", $slug);
$stmt->execute();
$result = $stmt->get_result();
$product = $result->fetch_assoc();

$is_admin = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $product ? htmlspecialchars($product['name']) : 'Product Not Found' ?> - Taji Yetu</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
<?php if ($is_admin): ?>
<link rel="stylesheet" href="admin-sidebar.css">
<?php endif; ?>
<style>
body {
  margin: 0;
  font-family: 'Segoe UI', sans-serif;
  background-color: #000;
  color: #fff;
}
main {
  padding-top: 70px;
  <?php if ($is_admin): ?> margin-left: 250px; <?php endif; ?>
  display: flex;
  justify-content: center;
}
.product-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  padding: 40px 20px;
  max-width: 600px;
  width: 100%;
}
.product-container h1 { font-size: 2.2rem; margin-bottom: 20px; }
.product-container img {
  max-width: 100%;
  border-radius: 10px;
  margin-bottom: 20px;
}
.product-container p { font-size: 20px; margin-bottom: 15px; }

/* Buttons styling */
.buttons {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 15px;
  margin-bottom: 10px;
}
.buy-btn {
  background: #fff;
  color: #000;
  border: none;
  padding: 12px 25px;
  font-weight: bold;
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.3s ease;
  text-decoration: none;
}
.buy-btn:hover {
  background: #28a745;
  color: #fff;
  transform: scale(1.05);
}

/* Cart icon + glitch */
.cart-glitch {
  display: flex;
  align-items: center;
  gap: 10px;
  margin-top: 10px;
  font-size: 1.3rem;
}
.glitch-text {
  font-weight: bold;
  color: #28a745;
  position: relative;
  font-size: 1.2rem;
  animation: glitch 2s infinite;
}
.glitch-text::before,
.glitch-text::after {
  content: 'Added to cart';
  position: absolute;
  top: 0;
  left: 0;
  color: #ff005e;
  clip-path: polygon(0 0, 100% 0, 100% 30%, 0 30%);
  animation: glitch 2s infinite;
}
.glitch-text::after {
  color: #00d4ff;
  clip-path: polygon(0 70%, 100% 70%, 100% 100%, 0 100%);
}
@keyframes glitch {
  0%,100% { transform: translate(0); }
  20% { transform: translate(-2px, 2px); }
  40% { transform: translate(2px, -2px); }
  60% { transform: translate(-1px,1px); }
  80% { transform: translate(1px,-1px); }
}

/* Popup notification */
#cart-popup {
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  background: #28a745;
  color: #fff;
  padding: 15px 25px;
  border-radius: 8px;
  font-weight: bold;
  display: none;
  z-index: 9999;
  box-shadow: 0 0 10px rgba(0,0,0,0.5);
}
</style>
</head>
<body>
<main>
  <?php if ($product): ?>
    <div class="product-container">
      <h1><?= htmlspecialchars($product['name']) ?></h1>
      <img src="uploads/<?= htmlspecialchars($product['image']) ?>" alt="<?= htmlspecialchars($product['name']) ?>">
      <p>Price: Ksh <?= number_format($product['price']) ?></p>

      <div class="buttons">
        <a class="buy-btn" href="#" data-id="<?= $product['id'] ?>">Add to Cart</a>
        <a class="buy-btn" href="listing.php">Back to Shopping</a>
      </div>

      <div class="cart-glitch" style="display:none;">
        <i class="fa-solid fa-cart-shopping"></i>
        <span class="glitch-text">Added to cart</span>
      </div>
    </div>
  <?php else: ?>
    <h2>Product not found.</h2>
  <?php endif; ?>

  <div id="cart-popup"></div>
  <?php include 'footer.php'; ?>
</main>

<script>
// Add to Cart AJAX
document.querySelector('.buy-btn[data-id]')?.addEventListener('click', async e => {
  e.preventDefault();
  const id = e.target.dataset.id;

  try {
    const res = await fetch(`add-to-cart.php?id=${id}`);
    const data = await res.json();
    if(data.success){
      // Show popup
      const popup = document.getElementById('cart-popup');
      popup.textContent = data.message;
      popup.style.display = 'block';
      setTimeout(() => { popup.style.display = 'none'; }, 1500);

      // Show cart icon + glitch text
      const cartDiv = document.querySelector('.cart-glitch');
      cartDiv.style.display = 'flex';
    } else {
      alert('Failed to add to cart.');
    }
  } catch(err){
    console.error('Add to cart error:', err);
  }
});
</script>

</body>
<?php include 'navbar.php'; ?>
<?php if ($is_admin): include 'admin-sidebar.php'; endif; ?>
</html>
