<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Check DB connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];
$displayName = $_SESSION['name'] ?? 'Account';

// Get cart count
$cart_count = 0;
if (isset($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $item) $cart_count += $item['quantity'];
}

// Fetch orders safely
$orders = [];
$stmt = $conn->prepare("SELECT order_id, order_date, status, total FROM orders WHERE user_id = ? ORDER BY order_date DESC");
if ($stmt) {
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
    }
    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Responsive scaling -->
<title>My Orders - Taji Yetu</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body { margin:0; font-family:'Segoe UI',sans-serif; background:#000; color:#fff; }
a { text-decoration:none; }
header { display:flex; justify-content:space-between; align-items:center; padding:15px 30px; background:#111; position: relative; }
.logo img { height:40px; }
.nav-links { display:flex; gap:20px; align-items:center; }
.nav-links a { color:#fff; font-weight:500; transition:0.3s; }
.nav-links a:hover { color:#aaa; }
.cart-wrapper { position:relative; display:inline-block; }
.cart-icon { font-size:1.3rem; cursor:pointer; }
.cart-badge { position:absolute; top:-8px; right:-10px; background:red; color:#fff; font-size:10px; font-weight:bold; border-radius:50%; padding:3px 6px; }
.account-dropdown { position:relative; }
.account-button { background:#222; color:#fff; border:none; padding:8px 16px; border-radius:20px; cursor:pointer; }
.dropdown-menu { display:none; position:absolute; right:0; top:100%; background:#222; border:1px solid #333; border-radius:5px; overflow:hidden; z-index:10; }
.dropdown-menu a { display:block; color:#fff; padding:10px 15px; }
.dropdown-menu a:hover { background:#333; }
.account-dropdown:hover .dropdown-menu { display:block; }
/* Hamburger */
.hamburger { display:none; flex-direction:column; cursor:pointer; gap:5px; }
.hamburger div { width:25px; height:3px; background:#fff; transition:0.3s; }
/* Container */
.container { max-width:900px; margin:30px auto; background:#1a1a1a; padding:25px; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.5); }
h1 { text-align:center; margin-bottom:25px; font-size:1.8rem; color:#f0f0f0; }
/* Table */
table { width:100%; border-collapse:collapse; }
th, td { padding:12px; text-align:center; border-bottom:1px solid #333; }
th { background:#222; }
tr:hover { background:#333; }
/* Responsive */
@media(max-width:768px) {
  .nav-links { display:none; flex-direction:column; background:#111; width:100%; position:absolute; top:60px; left:0; padding:10px 0; }
  .nav-links.active { display:flex; }
  .hamburger { display:flex; }
}
.actions { text-align:center; margin-top:20px; }
.actions a { background:#333; color:#fff; padding:10px 18px; margin:0 5px; border-radius:8px; transition:background 0.3s; }
.actions a:hover { background:#555; }
footer { background:#111; padding:20px; text-align:center; margin-top:40px; }
.social-icons a { color:#aaa; font-size:1.3rem; margin:0 10px; transition:color 0.3s; }
.social-icons a:hover { color:#fff; }
</style>
</head>
<body>
<header>
  <a href="index.php" class="logo"><img src="images/TAJI YETU.png" alt="Logo"></a>
  <div class="hamburger" onclick="document.querySelector('.nav-links').classList.toggle('active')">
    <div></div><div></div><div></div>
  </div>
  <div class="nav-links">
    <a href="index.php">Home</a>
    <a href="listing.php">Shop</a>
    <a href="profile.php">Profile</a>
    <a href="cart.php" class="cart-wrapper">
      Cart <i class="fas fa-shopping-cart cart-icon"></i>
      <span class="cart-badge"><?= $cart_count ?></span>
    </a>
    <div class="account-dropdown">
      <button class="account-button"><?= htmlspecialchars($displayName) ?> <i class="fas fa-caret-down"></i></button>
      <div class="dropdown-menu">
        <a href="profile.php">Profile</a>
        <a href="orders.php">Orders</a>
        <a href="logout.php">Logout</a>
      </div>
    </div>
  </div>
</header>

<div class="container">
  <h1>My Orders</h1>
  <?php if (!empty($orders)): ?>
    <table>
      <thead>
        <tr>
          <th>Order ID</th>
          <th>Date</th>
          <th>Status</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($orders as $order): ?>
          <tr>
            <td><?= htmlspecialchars($order['order_id']) ?></td>
            <td><?= htmlspecialchars(date('d M Y', strtotime($order['order_date']))) ?></td>
            <td><?= htmlspecialchars(ucfirst($order['status'])) ?></td>
            <td>Ksh <?= number_format($order['total'],2) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php else: ?>
    <p style="text-align:center; margin-top:20px;">You have not placed any orders yet.</p>
    <div class="actions">
      <a href="listing.php">Shop Now</a>
    </div>
  <?php endif; ?>
</div>

<footer>
  <div class="social-icons">
    <a href="#"><i class="fab fa-facebook-f"></i></a>
    <a href="#"><i class="fab fa-twitter"></i></a>
    <a href="#"><i class="fab fa-instagram"></i></a>
    <a href="#"><i class="fab fa-tiktok"></i></a>
  </div>
  <div>&copy; 2025 TAJI YETU. All rights reserved.</div>
</footer>

<script>
// Hamburger toggle
document.querySelector('.hamburger').addEventListener('click', function(){
  document.querySelector('.nav-links').classList.toggle('active');
});
</script>
</body>
</html>
