<?php
session_start();
require_once "db.php";

$isAdmin = $_SESSION['is_admin'] ?? 0;
$userName = $_SESSION['name'] ?? 'Admin';

if (!$isAdmin || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(403);
    exit('Forbidden');
}

$id = intval($_POST['id'] ?? 0);
if ($id > 0) {
    $stmt = $conn->prepare("UPDATE contact_messages SET read_status = 1, opened_by = :opened_by, opened_at = NOW() WHERE id = :id");
    $stmt->execute([
        ':opened_by' => $userName,
        ':id' => $id
    ]);
    echo 'success';
} else {
    http_response_code(400);
    echo 'Invalid ID';
}
