<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Connect to DB
    $conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }

    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Check user
    $stmt = $conn->prepare("SELECT id, firstName, lastName, phone, password, is_admin FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);

    if (!$stmt->execute()) {
        die("Query failed: " . $stmt->error);
    }

    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $firstName, $lastName, $phone, $hashedPassword, $isAdmin);
        $stmt->fetch();

        if (password_verify($password, $hashedPassword)) {
            // Save user session
            $_SESSION['user_id'] = $id;
            $_SESSION['firstName'] = $firstName;        // <-- Add this
            $_SESSION['lastName'] = $lastName;          // optional
            $_SESSION['name'] = $firstName . ' ' . $lastName;
            $_SESSION['phone'] = $phone;
            $_SESSION['email'] = $email;
            $_SESSION['is_admin'] = $isAdmin;
            $_SESSION['last_activity'] = time();

            // Redirect based on role
            if ($isAdmin == 1) {
                header("Location: admin-dashboard.php");
            } else {
                header("Location: index.php");
            }
            exit();
        } else {
            $error = "❌ Wrong password.";
        }
    } else {
        $error = "❌ No account found with that email.";
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login - Taji Yetu</title>
  <link href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:wght@700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <style>
    body {
      font-family: 'Old Standard TT', serif;
      background: url('images/1.png') center/cover no-repeat fixed;
      margin: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      color: #fff;
    }
    .container {
      background: rgba(0,0,0,0.85);
      padding: 30px; border-radius: 12px;
      width: 100%; max-width: 400px;
      box-shadow: 0 0 10px rgba(0,0,0,0.5);
    }
    h2 { text-align: center; margin-bottom: 25px; }
    form { display: flex; flex-direction: column; }
    label { margin-bottom: 6px; }
    input { padding: 10px; margin-bottom: 20px; border-radius: 6px; border: none; }
    input:focus { outline: none; box-shadow: 0 0 5px #fff; }
    button {
      background: #fff; color: #000; padding: 12px;
      border-radius: 8px; font-weight: bold;
      cursor: pointer; border: none;
    }
    button:hover { background: #ccc; }
    .error { color: #ff8080; text-align: center; margin-bottom: 15px; }
    a { color: #fff; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
  <div class="container">
    <h2>Login</h2>

    <?php if (!empty($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" action="login.php">
      <label for="email">Email</label>
      <input type="email" name="email" required />

      <label for="password">Password</label>
      <input type="password" name="password" required />

      <button type="submit">Login</button>
    </form>

    <p>Don't have an account? <a href="register.html">Register here</a></p>
  </div>
</body>
</html>
