<?php
require_once 'require_login.php';
$is_admin = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Products | Taji Yetu</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
<?php if ($is_admin): ?>
<link rel="stylesheet" href="admin-sidebar.css">
<?php endif; ?>
<style>
* {margin:0; padding:0; box-sizing:border-box;}
body { font-family: 'Segoe UI', sans-serif; background:#111; color:#fff; min-height:100vh; }

main { padding-top:70px; text-align:center; }
<?php if ($is_admin): ?> main { margin-left:250px; } <?php endif; ?>

h1 { font-size:2rem; margin-bottom:10px; }
h2.animate { font-size:1.5rem; margin-bottom:20px; }

/* Masonry */
.masonry { column-count:2; column-gap:1em; padding:0 20px; }
@media (min-width:768px){ .masonry{ column-count:3; } }
@media (min-width:1024px){ .masonry{ column-count:4; } }

.item {
  background:#1a1a1a; border-radius:10px; margin-bottom:1em;
  display:inline-block; width:100%; overflow:hidden;
  break-inside:avoid; transition: transform 0.3s; position:relative;
}
.item:hover { transform:translateY(-5px); }
.item img { width:100%; display:block; object-fit:cover; filter:grayscale(100%); transition:0.3s ease; }
.item:hover img { filter:grayscale(0%); transform:scale(1.02); }

.info { padding:15px; text-align:center; }
.product-name { font-size:16px; margin-bottom:5px; }
.product-price { font-size:14px; color:#ccc; margin-bottom:10px; }
.buy-button { padding:8px 16px; background:#fff; color:#000; border:none; font-weight:bold; border-radius:5px; cursor:pointer; transition:background 0.3s; margin:4px; display:inline-block; text-decoration:none; }
.buy-button:hover { background:#ccc; }

/* Cart icon on image */
.cart-icon-in-product { position:absolute; bottom:10px; left:10px; color:#28a745; font-size:1.3rem; }

/* Pop-up message */
#cart-popup {
  position:fixed; top:50%; left:50%; transform:translate(-50%,-50%);
  background:#28a745; color:#fff; padding:15px 25px; border-radius:8px;
  display:none; z-index:999; font-weight:bold;
}

/* Animation */
.Trousers { display:flex; justify-content:center; gap:15px; margin-bottom:20px; }
.Trousers div { animation:spinText 6s infinite; font-size:1.2rem; }
@keyframes spinText {
  0%{opacity:0; transform:translateY(-20px);}
  10%{opacity:1; transform:translateY(0);}
  25%{opacity:1;}
  30%{opacity:0; transform:translateY(20px);}
  100%{opacity:0;}
}
</style>
</head>
<body>

<?php include 'navbar.php'; ?>
<?php if ($is_admin) include 'admin-sidebar.php'; ?>


<main>
    
  <h1>Discover Our Latest Collection</h1>
  <div class="Trousers">
    <div>Shirts</div>
    <div>Dresses</div>
    <div>Hoodies</div>
    <div>EVERYTHING!</div>
  </div>
  <section class="masonry" id="product-list"></section>
  <div id="cart-popup"></div>
  
</main>

<script>
async function fetchProducts() {
  try {
    const res = await fetch('get-products.php');
    const data = await res.json();
    const container = document.getElementById('product-list');
    container.innerHTML = '';
    data.forEach(product => {
      const item = document.createElement('div');
      item.className = 'item';
      item.innerHTML = `
        <img src="uploads/${product.image}" alt="${product.name}">
        <div class="info">
          <div class="product-name">${product.name}</div>
          <div class="product-price">Ksh ${parseInt(product.price).toLocaleString()}</div>
          <div>
            <a class="buy-button" href="#" data-id="${product.id}">Add to Cart</a>
            <a class="buy-button" href="product.php?slug=${product.slug}">View Product</a>
          </div>
        </div>
        ${product.in_cart ? '<i class="fa-solid fa-cart-shopping cart-icon-in-product"></i>' : ''}
      `;
      container.appendChild(item);
    });
  } catch(e) { console.error(e); }
}
fetchProducts();

document.getElementById('product-list').addEventListener('click', async e => {
  if(e.target.matches('.buy-button[data-id]')) {
    e.preventDefault();
    const id = e.target.dataset.id;
    try {
      const res = await fetch(`add-to-cart.php?id=${id}`);
      const data = await res.json();
      if(data.success){
        // Show popup
        const popup = document.getElementById('cart-popup');
        popup.innerText = data.message;
        popup.style.display = 'block';
        setTimeout(()=>{popup.style.display='none';},1500);

        // Add icon
        const productDiv = e.target.closest('.item');
        if(!productDiv.querySelector('.cart-icon-in-product')){
          const icon = document.createElement('i');
          icon.className = 'fa-solid fa-cart-shopping cart-icon-in-product';
          productDiv.appendChild(icon);
        }
      }
    } catch(err){ console.error(err); }
  }
});
</script>
   <?php include 'footer.php'; ?>
</body>
</html>
