<?php
require_once 'require_login.php'; // Ensures session is started if login required

// Check if the user has just logged out
$showLogoutNotice = false;
if (isset($_SESSION['logged_out']) && $_SESSION['logged_out'] === true) {
    $showLogoutNotice = true;
    unset($_SESSION['logged_out']); // Remove the flag so popup appears only once
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
 <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Responsive scaling -->
<title>Home</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
<link rel="stylesheet" href="styles.css"> 
<style>
/* Page-specific styles */
body {
    display:flex;
    flex-direction:column;
    min-height:100vh;
    background: url('images/bg.jpg') center/cover no-repeat fixed;
    color:#fff;
}

/* Hero Section */
.hero { display:flex; justify-content:center; align-items:center; padding:80px 20px 20px; }
.overlay-text {
    display:flex; align-items:center; gap:20px;
    background: rgba(0,0,0,0.7); padding:20px; border-radius:10px; max-width:90%; flex-wrap:wrap;
}
.overlay-text img { width:100px; height:auto; border-radius:8px; flex-shrink:0; }
.overlay-text .text-content { flex:1; font-size:22px; line-height:1.4; }

/* Gallery */
.gallery { display:flex; justify-content:center; gap:10px; padding:30px 10px; flex-wrap:wrap; }
.gallery img { width:140px; height:200px; object-fit:cover; border-radius:10px; filter:grayscale(100%); transition: transform 0.3s ease; }
.gallery img:hover { transform: scale(1.05); filter: grayscale(0%); }
@media(max-width:768px){
    .gallery { overflow-x:auto; flex-wrap:nowrap; scroll-snap-type:x mandatory; -webkit-overflow-scrolling:touch; }
    .gallery img { flex:0 0 auto; scroll-snap-align:start; width:calc(33.33% - 10px); height:auto; }
}

/* Shop Now Button */
.shop-button { display:flex; justify-content:center; margin:20px auto; }
.shop-button button { background:#fff; color:#000; padding:12px 30px; font-size:18px; border:none; border-radius:5px; cursor:pointer; font-weight:bold; transition:0.3s ease; }
.shop-button button:hover { background:#ccc; }

/* Logout popup */
.logout-notice {
  position: fixed;
  top: 20px;
  right: 20px;
  background: #28a745;
  color: #fff;
  padding: 15px 20px;
  border-radius: 8px;
  font-weight: bold;
  box-shadow: 0 0 10px rgba(0,0,0,0.3);
  opacity: 0;
  animation: fadeInOut 4s forwards;
  z-index: 10000;
}

@keyframes fadeInOut {
  0% { opacity: 0; transform: translateY(-20px); }
  10% { opacity: 1; transform: translateY(0); }
  90% { opacity: 1; transform: translateY(0); }
  100% { opacity: 0; transform: translateY(-20px); }
}
</style>
</head>
<body>

<?php if ($showLogoutNotice): ?>
<div class="logout-notice">
  ✅ You have successfully logged out!
</div>
<?php endif; ?>

<?php include 'navbar.php'; ?>

<section class="hero">
    <div class="overlay-text">
        <img src="images/bg.jpg" alt="Model">
        <div class="text-content">
            <p>90% of the money made from these Belagids outfits go into the development and advancement of the Belagids vision.</p>
        </div>
    </div>
</section>

<section class="gallery">
    <img src="images/bw.jpeg" alt="Outfit 1">
    <img src="images/girl.jpeg" alt="Outfit 2">
    <img src="images/cargo pants.jpeg" alt="Outfit 3">
    <img src="images/girl2.jpeg" alt="Outfit 4">
    <img src="images/short black.jpeg" alt="Outfit 5">
</section>

<div class="shop-button">
    <button onclick="window.location.href='listing.php'">Shop Now</button>
</div>

<?php include 'footer.php'; ?>

</body>
</html>
