<?php
require_once 'require_login.php';
require_once 'db.php';

// Ensure admin
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    http_response_code(403);
    exit();
}

// Fetch stock info
$stmt = $conn->query("SELECT stock FROM products");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

$outOfStock = count(array_filter($products, fn($p) => $p['stock'] == 0));
$totalInStock = array_sum(array_column($products,'stock'));
$totalProducts = count($products);

echo json_encode([
    'outOfStock'=>$outOfStock,
    'totalInStock'=>$totalInStock,
    'totalProducts'=>$totalProducts
]);
