<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userId = $_SESSION['user_id'];

// Fetch current measurements
$stmt = $conn->prepare("SELECT gender, chest, waist, shoulders, bust FROM measurements WHERE user_id=?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$stmt->bind_result($gender, $chest, $waist, $shoulders, $bust);
$stmt->fetch();
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Measurements - Taji Yetu</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
<style>
/* Base Styles */
body { margin:0; font-family:'Segoe UI', sans-serif; background:#000; color:#fff; }
header { display:flex; justify-content:space-between; align-items:center; padding:15px 30px; background:rgba(17,17,17,0.9); position:sticky; top:0; z-index:1000; flex-wrap:wrap; }
.logo img { height:40px; }
.nav-links { display:flex; gap:20px; }
.nav-links a { color:#fff; text-decoration:none; font-weight:500; transition:0.3s; }
.nav-links a:hover { color:#aaa; }
.cart-wrapper { position:relative; }
.cart-icon { font-size:1.3rem; cursor:pointer; color:#fff; }
.cart-badge { position:absolute; top:-8px; right:-10px; background:red; color:#fff; font-size:10px; font-weight:bold; border-radius:50%; padding:3px 6px; }
.hamburger { display:none; font-size:1.5rem; cursor:pointer; }
.account-dropdown { position:relative; }
.account-button { background:#222; color:#fff; border:none; padding:8px 16px; border-radius:20px; cursor:pointer; }
.dropdown-menu { display:none; position:absolute; right:0; top:100%; background:#222; border:1px solid #333; border-radius:5px; overflow:hidden; z-index:10; }
.dropdown-menu a { display:block; color:#fff; text-decoration:none; padding:10px 15px; transition:background 0.3s; }
.dropdown-menu a:hover { background:#333; }
.account-dropdown:hover .dropdown-menu { display:block; }

/* Container */
.container { max-width:600px; margin:40px auto; background:#1a1a1a; padding:25px; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.5); }
h1 { text-align:center; margin-bottom:25px; color:#f0f0f0; }
form { display:flex; flex-direction:column; gap:15px; }
input, select { padding:12px; border-radius:6px; border:1px solid #555; background:#222; color:#fff; font-size:14px; }
input:focus, select:focus { outline:none; border-color:#fff; }
button { padding:12px; border:none; border-radius:6px; font-size:16px; cursor:pointer; transition:0.3s; }
button.save-btn { background:#fff; color:#000; }
button.save-btn:hover { background:#ccc; }
button.cancel-btn { background:#333; color:#fff; }
button.cancel-btn:hover { background:#555; }

/* Responsive */
@media(max-width:768px){
    .nav-links { display:none; flex-direction:column; gap:10px; background:#111; width:100%; padding:15px; }
    .nav-links.active { display:flex; }
    .hamburger { display:block; color:#fff; }
}
</style>
</head>
<?php include "navbar.php"; ?>
<body>


<!-- Edit Form -->
<div class="container">
    <h1>Edit Measurements</h1>
    <form action="save-measurements.php" method="post">
        <select name="gender" required>
            <option value="" <?= empty($gender) ? 'selected' : '' ?>>Add your gender</option>
            <option value="Male" <?= $gender === 'Male' ? 'selected' : '' ?>>Male</option>
            <option value="Female" <?= $gender === 'Female' ? 'selected' : '' ?>>Female</option>
        </select>
        <input type="number" step="0.1" name="chest" placeholder="Add your chest measurement (cm)" value="<?= htmlspecialchars($chest) ?>">
        <input type="number" step="0.1" name="waist" placeholder="Add your waist measurement (cm)" value="<?= htmlspecialchars($waist) ?>">
        <input type="number" step="0.1" name="shoulders" placeholder="Add your shoulder measurement (cm)" value="<?= htmlspecialchars($shoulders) ?>">
        <input type="number" step="0.1" name="bust" placeholder="Add your bust measurement (cm)" value="<?= htmlspecialchars($bust) ?>">
        <div style="display:flex; gap:10px;">
            <button type="submit" class="save-btn">Save</button>
            <a href="profile.php"><button type="button" class="cancel-btn">Cancel</button></a>
        </div>
    </form>
</div>


<script>
// Hamburger menu toggle
function toggleMenu(){
    document.querySelector('.nav-links').classList.toggle('active');
}

// Fetch cart count dynamically
async function updateCartCount(){
    try{
        const res = await fetch('get_cart.php');
        const data = await res.json();
        let count = 0;
        if(data.cart){
            data.cart.forEach(item=> count += parseInt(item.quantity));
        }
        document.getElementById('cartCount').textContent = count;
    } catch(e){ console.error(e); }
}
updateCartCount();
</script>


</html>
</body><?php include "footer.php"; ?>
