<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Only allow admins
if (!isset($_SESSION['user_id']) || ($_SESSION['is_admin'] ?? 0) != 1) {
    header("Location: login.php");
    exit();
}

// Get product ID from query
$id = intval($_GET['id'] ?? 0);
if (!$id) {
    header("Location: admin-products.php");
    exit();
}

// Fetch product image
$stmt = $conn->prepare("SELECT image FROM products WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($image_name);
$stmt->fetch();
$stmt->close();

// Delete product from database
$stmt = $conn->prepare("DELETE FROM products WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->close();

// Delete image file if exists
if (!empty($image_name) && file_exists("uploads/$image_name")) {
    unlink("uploads/$image_name");
}

// Redirect back to admin-products.php
header("Location: admin-products.php");
exit();
