<?php
session_start();
$conn = new mysqli("localhost", "kkfxoaad", "Bitok@2025", "kkfxoaad_bella");

// Redirect if not logged in or session expired
if (!isset($_SESSION['user_id']) || (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600))) {
    if (isset($_SESSION['user_id'])) unset($_SESSION['user_id']);
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit();
}
$_SESSION['last_activity'] = time();

$userId = $_SESSION['user_id'];

// Check if user is admin
$adminStmt = $conn->prepare("SELECT is_admin, firstName, lastName FROM users WHERE id = ?");
$adminStmt->bind_param("i", $userId);
$adminStmt->execute();
$adminStmt->bind_result($is_admin, $firstName, $lastName);
$adminStmt->fetch();
$adminStmt->close();

if ($is_admin != 1) {
    header("Location: index.php");
    exit();
}
$displayName = trim(($firstName ?? '') . " " . ($lastName ?? ''));

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fname = trim($_POST['firstName']);
    $lname = trim($_POST['lastName']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    $stmt = $conn->prepare("INSERT INTO users (firstName, lastName, email, phone, password, is_admin) VALUES (?, ?, ?, ?, ?, 0)");
    $stmt->bind_param("sssss", $fname, $lname, $email, $phone, $password);

    if ($stmt->execute()) {
        $stmt->close();
        $conn->close();
        header("Location: user_management.php?msg=added");
        exit();
    } else {
        $error = "Failed to add user: " . $stmt->error;
    }
    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add User - Taji Yetu</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body { margin:0; font-family:'Segoe UI',sans-serif; background:#f5f5f5; color:#333; }
a { text-decoration:none; }

/* Navbar (profile style, white background) */
header { display:flex; justify-content:space-between; align-items:center; padding:15px 30px; background:#fff; border-bottom:1px solid #ddd; position: relative; }
.logo img { height:40px; }
.nav-links { display:flex; gap:20px; align-items:center; }
.nav-links a { color:#333; font-weight:500; transition:0.3s; }
.nav-links a:hover { color:#666; }
.cart-wrapper { position:relative; display:inline-block; }
.cart-icon { font-size:1.3rem; cursor:pointer; color:#333; }
.cart-badge { position:absolute; top:-8px; right:-10px; background:red; color:#fff; font-size:10px; font-weight:bold; border-radius:50%; padding:3px 6px; }
.account-dropdown { position:relative; }
.account-button { background:#eee; color:#333; border:none; padding:8px 16px; border-radius:20px; cursor:pointer; }
.dropdown-menu { display:none; position:absolute; right:0; top:100%; background:#fff; border:1px solid #ddd; border-radius:5px; overflow:hidden; z-index:10; }
.dropdown-menu a { display:block; color:#333; padding:10px 15px; }
.dropdown-menu a:hover { background:#f0f0f0; }
.account-dropdown:hover .dropdown-menu { display:block; }
.hamburger { display:none; flex-direction:column; cursor:pointer; gap:5px; }
.hamburger div { width:25px; height:3px; background:#333; transition:0.3s; }

/* Container */
.container { max-width:600px; margin:40px auto; background:#fff; padding:25px; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.1); }
h1 { text-align:center; margin-bottom:25px; font-size:1.8rem; color:#222; }

/* Form */
form { display:flex; flex-direction:column; }
label { margin:8px 0 4px; font-weight:500; }
input { padding:10px; border:1px solid #ccc; border-radius:6px; margin-bottom:15px; font-size:14px; }
button { background:#111; color:#fff; padding:12px; border:none; border-radius:6px; cursor:pointer; font-size:16px; }
button:hover { background:#333; }
.error { color:red; text-align:center; margin-bottom:15px; }

footer { background:#fff; padding:25px 20px; text-align:center; margin-top:40px; border-top:1px solid #ddd; }
.social-icons { margin-bottom:15px; }
.social-icons a { color:#555; font-size:1.3rem; margin:0 10px; transition:color 0.3s; }
.social-icons a:hover { color:#111; }
</style>
</head>
<body>
<header>
  <a href="<?= $is_admin ? 'admin-dashboard.php' : 'index.php' ?>" class="logo"><img src="images/TAJI YETU.png" alt="Logo"></a>
  <div class="hamburger" onclick="document.querySelector('.nav-links').classList.toggle('active')">
    <div></div><div></div><div></div>
  </div>
  <div class="nav-links">
    <a href="<?= $is_admin ? 'admin-dashboard.php' : 'index.php' ?>">Home</a>
    <a href="listing.php">Products</a>
    <a href="index.php">About</a>
    <div class="account-dropdown">
      <button class="account-button"><?= htmlspecialchars($displayName ?: 'Account') ?> <i class="fas fa-caret-down"></i></button>
      <div class="dropdown-menu">
        <a href="profile.php">Profile</a>
        <a href="logout.php">Logout</a>
      </div>
    </div>
  </div>
</header>

<div class="container">
  <h1>Add New User</h1>
  <?php if (!empty($error)): ?>
    <div class="error"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>
  <form method="POST" action="add-user.php">
    <label for="firstName">First Name</label>
    <input type="text" name="firstName" id="firstName" required>
    <label for="lastName">Last Name</label>
    <input type="text" name="lastName" id="lastName" required>
    <label for="email">Email</label>
    <input type="email" name="email" id="email" required>
    <label for="phone">Phone</label>
    <input type="text" name="phone" id="phone" required>
    <label for="password">Password</label>
    <input type="password" name="password" id="password" required>
    <button type="submit">Add User</button>
  </form>
</div>

<footer>
  <div class="social-icons">
    <a href="#"><i class="fab fa-facebook-f"></i></a>
    <a href="#"><i class="fab fa-twitter"></i></a>
    <a href="#"><i class="fab fa-instagram"></i></a>
    <a href="#"><i class="fab fa-tiktok"></i></a>
  </div>
  <div class="copyright">&copy; 2025 TAJI YETU. All rights reserved.</div>
</footer>
</body>
</html>
