<?php
session_start();
$is_admin = isset($_SESSION['is_admin']) ? intval($_SESSION['is_admin']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>About — Taji Yetu</title>

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Sidebar CSS -->
  <link rel="stylesheet" href="admin-sidebar.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

  <style>
    :root {
      --bg: #000;
      --muted: #bdbdbd;
      --white: #ffffff;
      --glass-alpha: 0.06;
      --accent-blue: #007bff;
      --accent-orange: #fd7e14;
      --max-width: 1200px;
      --gap: 24px;
      --radius: 12px;
    }

    * { box-sizing: border-box; }
    html, body { height: 100%; margin: 0; }
    body {
      background: var(--bg);
      color: var(--white);
      font-family: 'Inter', system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      line-height: 1.45;
    }
    a { color: inherit; text-decoration: none; }
    img { max-width: 100%; display: block; height: auto; }

    .page { position: relative; min-height: 100vh; overflow-x: hidden; }

    /* background animations */
    .bg-animations {
      position: fixed; inset: 0; pointer-events: none; z-index: 0; opacity: 0.65; mix-blend-mode: screen;
    }
    .bg-animations .shape {
      position: absolute; border-radius: 22%;
      background: linear-gradient(135deg, rgba(255,255,255,0.05), rgba(255,255,255,0.02));
      filter: blur(18px);
      animation: floatY 10s ease-in-out infinite;
    }
    .bg-animations .s1{ left:6%; top:8%; width:220px; height:220px; animation-delay:0s;}
    .bg-animations .s2{ right:6%; top:18%; width:140px; height:140px; animation-delay:2s;}
    .bg-animations .s3{ left:12%; bottom:8%; width:160px; height:160px; animation-delay:4s;}
    .bg-animations .s4{ right:18%; bottom:12%; width:200px; height:200px; animation-delay:6s;}
    @keyframes floatY {
      0% { transform:translateY(0) rotate(0deg) }
      50% { transform:translateY(-18px) rotate(6deg) }
      100% { transform:translateY(0) rotate(0deg) }
    }
    .bg-lines { position: fixed; inset:0; z-index:0; pointer-events:none; }
    .bg-lines svg { width:100%; height:100%; opacity:0.08; }

    /* layout */
    .dashboard-wrapper {
      display: flex;
      min-height: calc(100vh - 60px); /* account for fixed navbar */
      margin-top: 60px;
      max-width: var(--max-width);
      margin-left: auto;
      margin-right: auto;
      position: relative;
      z-index: 2;
    }
    .main-content {
      flex: 1;
      padding: 28px 20px 80px;
    }

    /* hero */
    .hero {
      display: flex; flex-direction: column; gap: 18px; align-items: flex-start;
      padding: 36px;
      background: linear-gradient(180deg, rgba(255,255,255,var(--glass-alpha)), rgba(255,255,255,0.02));
      border-radius: var(--radius);
      border: 1px solid rgba(255,255,255,0.04);
      box-shadow: 0 6px 30px rgba(0,0,0,0.6);
    }
    .eyebrow { font-size: 13px; color: var(--muted); text-transform: uppercase; font-weight: 600; }
    .hero-title { font-size: clamp(26px, 4.5vw, 44px); font-weight: 700; margin: 0; }
    .hero-sub { color: var(--muted); max-width: 820px; font-size: 15px; margin-top: 6px; }

    .btn {
      display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 10px 14px;
      border-radius: 8px; font-weight: 600; font-size: 14px; color: var(--white); cursor: pointer; border: 0;
    }
    .btn-blue { background: var(--accent-blue); }
    .btn-orange { background: var(--accent-orange); }

    /* grids */
    .grid { display: grid; grid-template-columns: 1fr; gap: var(--gap); margin-top: 28px; }
    .story { background: transparent; padding: 20px; border-radius: 10px; }
    .story p { color: var(--muted); margin: 0 0 12px 0; }
    .highlights { display: flex; gap: 14px; margin-top: 12px; flex-wrap: wrap; }
    .card { background: rgba(255,255,255,0.02); padding: 16px; border-radius: 10px; flex: 1; min-width: 160px; }
    .card h4 { margin: 0 0 8px 0; font-size: 16px; }
    .card p { margin: 0; color: var(--muted); font-size: 14px; }

    .values { display: grid; gap: var(--gap); margin-top: 24px; }
    .values .value-item { padding: 18px; border-radius: 10px; background: rgba(255,255,255,0.01); }
    .values h3 { margin: 0 0 10px 0; }
    .values p { margin: 0; color: var(--muted); }

    .brand-visual { margin-top: 20px; display: flex; gap: 18px; align-items: center; }
    .brand-text { color: var(--muted); font-size: 14px; }

    /* responsive */
    @media(min-width:880px){
      .grid { grid-template-columns: 1fr 360px; align-items: start; }
      .values { grid-template-columns: 1fr 1fr; }
    }
    @media(max-width:768px){
      .dashboard-wrapper { flex-direction: column; margin-top: 60px; }
      .sidebar { display: none; }
    }
  </style>
</head>
<body>
  <div class="page">
    <!-- background -->
    <div class="bg-animations" aria-hidden="true">
      <div class="shape s1"></div><div class="shape s2"></div><div class="shape s3"></div><div class="shape s4"></div>
    </div>
    <div class="bg-lines" aria-hidden="true">
      <svg viewBox="0 0 100 100" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
        <defs><linearGradient id="g" x1="0" x2="1">
          <stop offset="0" stop-color="#fff" stop-opacity="0.06"/>
          <stop offset="1" stop-color="#fff" stop-opacity="0.02"/>
        </linearGradient></defs>
        <path d="M0 100 L100 0" stroke="url(#g)" stroke-width="0.8" stroke-linecap="round"></path>
        <path d="M0 75 L75 0" stroke="url(#g)" stroke-width="0.6" stroke-linecap="round"></path>
        <path d="M25 100 L100 25" stroke="url(#g)" stroke-width="0.6" stroke-linecap="round"></path>
      </svg>
    </div>

    <?php include 'navbar.php'; ?>

    <div class="dashboard-wrapper">
      <?php if ($is_admin): ?>
        <div class="sidebar"><?php include 'admin-sidebar.php'; ?></div>
      <?php endif; ?>

      <main class="main-content" role="main" aria-labelledby="about-heading">
        <!-- Hero -->
        <section class="hero" aria-labelledby="about-heading">
          <div class="eyebrow">About</div>
          <h1 id="about-heading" class="hero-title">Taji Yetu - Drip All the way</h1>
          <p class="hero-sub">Taji Yetu blends contemporary design with responsible production. From elevated everyday essentials to statement pieces, we create clothing that feels timeless — and kind to the people who make it.</p>

          <div class="hero-ctas">
            <a class="btn btn-orange" href="listing.php"><i class="fas fa-shopping-bag"></i> Continue Shopping</a>
            <a class="btn btn-blue" href="#craftsmanship"><i class="fas fa-seedling"></i> Our Materials</a>
          </div>

          <div class="brand-visual" aria-hidden="true">
            <img src="images/taji-yetu.png" alt="Taji Yetu Logo" style="width:64px;height:auto;">
            <div class="brand-text">Taji Yetu — Nairobi-born, globally inspired. Rooted in craft, driven by style.</div>
          </div>
        </section>

        <!-- Story + quick facts -->
        <div class="grid">
          <article class="story">
            <h2 style="margin-top:0">Our Story</h2>
            <p>Founded in 2021, Taji Yetu began as a small creative collective with a simple idea: make modern fashion that respects people and planet.</p>
            <p>Our inspiration comes from everyday movement — the way fabric folds when you walk, how a silhouette changes with light, and the confidence that comes from wearing something made just for you.</p>

            <div class="highlights">
              <div class="card"><h4>Timeless Design</h4><p>Clean silhouettes, modern tailoring, and pieces that work across seasons.</p></div>
              <div class="card"><h4>Responsible Sourcing</h4><p>We prioritize low-impact materials and fair partnerships with suppliers.</p></div>
              <div class="card"><h4>Quality Craftsmanship</h4><p>Garments assembled by skilled makers with attention to fit and finish.</p></div>
            </div>

            <div class="values">
              <div class="value-item"><h3>Mission</h3><p>To make thoughtfully designed clothing that empowers confidence and minimizes environmental impact.</p></div>
              <div class="value-item"><h3>Vision</h3><p>A future where style and sustainability walk hand-in-hand — accessible to as many people as possible.</p></div>
            </div>

            <section id="craftsmanship" style="margin-top:18px;">
              <h3>Craft & Materials</h3>
              <p>We source natural fibers like organic cotton, linen, and Tencel, and combine them with durable trims. Each collection contains a signature limited run of locally made pieces to support artisans and reduce overproduction.</p>
            </section>
          </article>

          <aside class="story">
            <h3>Quick Facts</h3>
            <p><strong>Founded:</strong> 2021</p>
            <p><strong>Made in:</strong> Nairobi / Local ateliers</p>
            <p><strong>Focus:</strong> Everyday elevated, sustainable practices</p>

            <h4>Community</h4>
            <p>We collaborate with local tailors and makers, running small capsule lines to fund training and craft development.</p>

            <div style="margin-top:16px;">
              <h4>Follow Us</h4>
              <div style="display:flex; gap:10px; margin-bottom:12px;">
                <a class="btn btn-blue" href="#"><i class="fab fa-instagram"></i></a>
                <a class="btn btn-blue" href="#"><i class="fab fa-tiktok"></i></a>
                <a class="btn btn-blue" href="#"><i class="fab fa-facebook"></i></a>
              </div>

              <h4>Visit Us</h4>
              <p>Pop into our studio for fittings by appointment — we love meeting our community in person.</p>
            </div>
          </aside>
        </div>

        <section style="margin-top:30px;">
          <h3>Meet the Founder</h3>
          <p>Amina Ndungu — designer & founder. Amina trained in tailoring and product design and started Taji Yetu to make considered fashion that fits modern life.</p>
        </section>

        <div style="margin-top:32px; color:var(--muted); font-size:13px;">
          <p>Questions about fit or custom orders? <a href="contactus.php" style="color:var(--white); text-decoration:underline">Contact our team</a>.</p>
        </div>
      </main>
    </div>

    <?php include 'footer.php'; ?>
  </div>

  <script>
    (function(){
      function reduceMotion() {
        if (window.matchMedia('(max-width:600px)').matches || window.matchMedia('(prefers-reduced-motion: reduce)').matches) {
          document.querySelectorAll('.bg-animations .shape').forEach(s => {
            s.style.opacity = '0.45';
            s.style.filter = 'blur(12px)';
            s.style.animationDuration = '18s';
          });
          document.querySelectorAll('.bg-lines svg').forEach(svg => svg.style.opacity = '0.04');
        }
      }
      reduceMotion();
      window.addEventListener('resize', reduceMotion);
    })();
  </script>
</body>
</html>
